set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '3',
      '4',
      '2',
      '4',
      NULL,
      '3',
      '3',
      '1',
      NULL,
      '2',
      '4',
      NULL,
      '0',
      NULL,
      '4',
      '3',
      '0',
      '3',
      '1',
      '3',
      NULL,
      '1',
      '',
      '2',
      '',
      NULL,
      NULL,
      '1',
      '0',
      '0',
      '',
      NULL,
      '3',
      '3',
      '0',
      '3',
      '4',
      '2',
      '0',
      '2',
      '1',
      '0',
      '3',
      '332',
      '4',
      10.174065,
      NULL,
      '3321424',
      2,
      23.094835,
      3,
      1,
      '232241',
      4.076992,
      ' 9-26-1995',
      ' 0-15-1977',
      39,
      87,
      12,
      NULL,
      10.035796,
      7,
      NULL,
      15.334921,
      NULL,
      5,
      10.378784,
      12,
      6.691942,
      13.500691,
      4,
      NULL,
      12,
      11.551462,
      3.705290,
      NULL,
      31.517863,
      11,
      3,
      4,
      NULL,
      36.839883,
      119.922021,
      48,
      4,
      4.098829,
      128,
      '11-20-1978',
      NULL,
      1.401233,
      3,
      16,
      88,
      NULL,
      '11-15-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      5.600297,
      18.188264,
      16.676944,
      NULL,
      4,
      NULL,
      1.290303,
      0.984240,
      4.423167,
      1.113237,
      3,
      9.285981,
      0.465717,
      6,
      14,
      NULL,
      NULL,
      NULL,
      ' 3- 1-2000',
      17,
      52,
      31.668837,
      57,
      41,
      62.472007,
      NULL,
      68,
      19.007864,
      17.775280,
      71,
      NULL,
      ' 4-11-2001',
      NULL,
      NULL,
      10.893111,
      13.813124,
      14.297681,
      7,
      NULL,
      ' 7- 8-1991',
      13,
      13.951120,
      NULL,
      NULL,
      4.041450,
      9.671331,
      10.030092,
      4.076619,
      6,
      0,
      4,
      1,
      17.513285,
      0.307448,
      NULL,
      NULL,
      5.236404,
      1,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      ' 4-14-1984',
      NULL,
      NULL,
      NULL,
      6.267712,
      ' 7-25-1981',
      6.999358,
      ' 7-18-1998',
      NULL,
      NULL,
      ' 7-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.452874,
      '10-28-1979',
      NULL,
      11,
      27,
      ' 8-11-1984',
      5,
      231,
      ' 1-26-1995',
      NULL,
      57,
      3,
      44,
      ' 3-20-1997',
      5,
      0.490277,
      100,
      ' 6-18-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


