set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2132',
      '40423410',
      '14222102',
      '12010144',
      '20230100',
      '12233114',
      '11120110',
      '21301314',
      '02021000',
      NULL,
      '41313231',
      NULL,
      '41012420',
      '00204124',
      '40143133',
      '20023000',
      NULL,
      NULL,
      NULL,
      '41211411',
      '44242000',
      '34022331',
      '32413343',
      NULL,
      '03402321',
      NULL,
      '21041211',
      NULL,
      '01124030',
      '30204132',
      '02100213',
      '20443423',
      '42334322',
      '11341124',
      '20121320',
      '24443041',
      '41432431',
      '40114114',
      '00131332',
      '21121100',
      '04431213',
      '02143333',
      NULL,
      '31300030',
      '24122212',
      '012',
      '34',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      '023433',
      0,
      ' 5-22-1979',
      ' 1-27-1982',
      59.612167,
      NULL,
      NULL,
      22,
      0.042542,
      6.612646,
      29.254199,
      NULL,
      11,
      10,
      NULL,
      23,
      14.789615,
      NULL,
      5.609181,
      4.840277,
      2.316702,
      18,
      NULL,
      2,
      24,
      8.994974,
      99.440149,
      NULL,
      1.795160,
      26.080517,
      NULL,
      98.699089,
      56.588669,
      NULL,
      164,
      ' 8-28-2000',
      47.516280,
      17,
      NULL,
      13,
      50,
      22.248657,
      '10- 6-1980',
      NULL,
      3.863964,
      3.747382,
      3,
      0,
      NULL,
      4,
      3,
      0,
      1,
      2,
      1.108155,
      2.514111,
      0,
      1.069480,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-16-1976',
      13,
      33,
      NULL,
      29.030012,
      8.148667,
      0.577424,
      ' 8-28-1997',
      1.412810,
      0.320355,
      112,
      0.941020,
      1.169036,
      14,
      0,
      0,
      18,
      NULL,
      NULL,
      NULL,
      ' 7- 9-1986',
      NULL,
      67,
      23,
      77.560181,
      50,
      49.797906,
      NULL,
      19.628859,
      NULL,
      NULL,
      34,
      35.419101,
      ' 4-27-1978',
      7.813837,
      0.733061,
      0.813078,
      28,
      NULL,
      NULL,
      7.850392,
      ' 0-24-1997',
      9.145854,
      1.122834,
      ' 8-28-1977',
      4.886231,
      NULL,
      5,
      16.844677,
      20,
      7.499093,
      0.449699,
      15,
      NULL,
      80,
      2.431475,
      1.875684,
      12,
      22.064389,
      3,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.801563,
      ' 2-23-1979',
      29.129569,
      NULL,
      9.181131,
      7.082275,
      ' 2-12-1995',
      NULL,
      93.473031,
      ' 1-12-2000',
      NULL,
      5.383555,
      ' 4- 4-1998',
      NULL,
      NULL,
      NULL,
      3,
      2,
      16.726227,
      ' 6- 1-1975',
      NULL,
      23,
      20.372831,
      ' 8-27-1989',
      0,
      NULL,
      '11-12-1986',
      0,
      22.656710,
      NULL,
      19.773169,
      '11-29-1978',
      36.498421,
      NULL,
      137.342625,
      ' 8-10-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


