set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12413140',
      '41200422',
      '21131012',
      '43023001',
      '42121021',
      '23311102',
      '12044010',
      '31201003',
      '01210440',
      NULL,
      '23421030',
      '12143323',
      '31043223',
      '34021010',
      '22340222',
      NULL,
      '11040310',
      '23141334',
      '13324314',
      NULL,
      '43012243',
      '24310022',
      '04401424',
      '20210204',
      '21032401',
      NULL,
      '23040340',
      '34330300',
      '43100401',
      NULL,
      '42432020',
      NULL,
      '23010432',
      '04403200',
      '02130230',
      '23334440',
      '33042441',
      '02431331',
      '43231213',
      '31322241',
      '02113424',
      '10432012',
      '21104440',
      '33032143',
      '330',
      '21',
      14.640641,
      NULL,
      '3413004',
      2,
      25,
      1,
      NULL,
      '100224',
      1.035524,
      ' 5-13-1976',
      NULL,
      33.894814,
      55.381280,
      49,
      0,
      12,
      4.298338,
      10.928270,
      12,
      7.356585,
      17,
      7,
      9.932240,
      4.917352,
      25.389756,
      8,
      20,
      26,
      21.704145,
      NULL,
      13.567234,
      58.080075,
      2.140924,
      126,
      26,
      1.918614,
      0.574502,
      16,
      76,
      69.806322,
      49,
      NULL,
      ' 6- 0-1977',
      16.884060,
      36.119210,
      23.262548,
      17.016492,
      143.443516,
      124,
      ' 2- 4-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.900676,
      12.235375,
      1.306898,
      NULL,
      NULL,
      7,
      ' 3-18-1994',
      NULL,
      1,
      169.873366,
      0.485341,
      1.460906,
      87.848275,
      NULL,
      1.268190,
      53.039290,
      NULL,
      NULL,
      NULL,
      ' 8-16-1980',
      78,
      74.699769,
      10.620123,
      NULL,
      21,
      14.859603,
      64,
      71,
      77.366574,
      NULL,
      83,
      56.148691,
      ' 0- 1-1996',
      2.981757,
      11.189103,
      16.551756,
      33,
      NULL,
      4,
      4,
      ' 9-22-1976',
      5.139415,
      8.503695,
      ' 7- 4-1979',
      8,
      NULL,
      2,
      0.694941,
      1.964537,
      NULL,
      NULL,
      NULL,
      NULL,
      14.744530,
      0.419164,
      0.450462,
      1.725444,
      26.560741,
      2,
      2,
      1,
      1,
      ' 2- 7-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      15.055338,
      NULL,
      ' 5-24-2003',
      NULL,
      NULL,
      NULL,
      44,
      ' 4-27-1975',
      4,
      NULL,
      10.297800,
      8,
      NULL,
      70.757317,
      81.579269,
      '10-21-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8.079903,
      ' 9-24-1983',
      53.111041,
      35,
      65.234831,
      NULL,
      0,
      NULL,
      ' 9- 4-1988',
      1,
      66.303583,
      17.126334,
      50,
      NULL,
      42.000382,
      1,
      79,
      ' 6- 3-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


