set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '2',
      '3',
      '2',
      NULL,
      '4',
      '4',
      '0',
      '3',
      '0',
      '3',
      '1',
      '4',
      '1',
      '2',
      NULL,
      '2',
      '4',
      '3',
      '2',
      '4',
      '0',
      NULL,
      '',
      '3',
      '',
      NULL,
      '1',
      '2',
      NULL,
      '1',
      '',
      '',
      '0',
      '4',
      '3',
      '1',
      '3',
      '0',
      '4',
      '4',
      '0',
      '1',
      NULL,
      '030',
      '43404413',
      12.220907,
      45,
      '0120113',
      1.295329,
      81.091279,
      2,
      NULL,
      '220330',
      1.934209,
      ' 1-22-1994',
      NULL,
      NULL,
      154.478415,
      27.521098,
      23,
      2.156214,
      13,
      NULL,
      16,
      27.443153,
      14,
      18,
      10.401629,
      18,
      13,
      15,
      23.705339,
      20.675723,
      19.562890,
      63,
      NULL,
      32,
      18,
      NULL,
      2,
      NULL,
      36.179108,
      NULL,
      97,
      65,
      NULL,
      21.996850,
      '10-20-1987',
      13,
      11,
      19.849535,
      NULL,
      74.267237,
      178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      12,
      8,
      NULL,
      7,
      3.946226,
      NULL,
      NULL,
      0.877396,
      20.549144,
      0,
      1,
      46.135421,
      1,
      0,
      34.138178,
      NULL,
      NULL,
      NULL,
      '11- 1-1996',
      96,
      72,
      55,
      42,
      14.042129,
      39.553892,
      8.437885,
      NULL,
      50,
      42,
      14,
      14,
      '11-27-1997',
      15.374889,
      9.147635,
      6,
      NULL,
      21.282427,
      NULL,
      NULL,
      ' 6-14-1982',
      0.837367,
      12,
      ' 8-29-2003',
      11,
      NULL,
      12,
      8,
      3.028874,
      3.771421,
      1.985793,
      NULL,
      0,
      69,
      1.729805,
      1,
      7,
      9.616066,
      6,
      0.291749,
      1,
      1.726194,
      ' 3- 5-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      155.687310,
      27.766186,
      ' 4-20-1997',
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      6.251301,
      ' 7-12-2000',
      4,
      NULL,
      NULL,
      83,
      76,
      ' 4-11-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      ' 5-17-1998',
      NULL,
      NULL,
      57,
      ' 4-17-2003',
      3,
      NULL,
      NULL,
      5.499471,
      19,
      10,
      6,
      ' 3-24-1982',
      5.236804,
      1.666778,
      54,
      ' 7- 7-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


