set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '1',
      '2',
      '1',
      '2',
      NULL,
      '3',
      '4',
      '0',
      '3',
      '0',
      NULL,
      '4',
      '2',
      '2',
      '2',
      '2',
      '2',
      '1',
      '4',
      '0',
      NULL,
      '1',
      '',
      '3',
      '',
      '0',
      '4',
      '1',
      '4',
      '2',
      NULL,
      '',
      '3',
      '0',
      '4',
      '3',
      '2',
      '2',
      '1',
      '2',
      '3',
      '4',
      NULL,
      NULL,
      '20213403',
      16.716140,
      81.031006,
      '0130231',
      1.435526,
      65,
      2,
      0,
      NULL,
      4.757160,
      ' 8-11-2002',
      '11- 5-2003',
      52.364071,
      NULL,
      NULL,
      0.846833,
      1.338385,
      16,
      58.422721,
      11.340115,
      NULL,
      2,
      19,
      NULL,
      39.308466,
      17.028278,
      8,
      24,
      13.751946,
      24.720519,
      NULL,
      11.198200,
      NULL,
      NULL,
      48.781238,
      2,
      0.157172,
      57.164027,
      164.475286,
      54,
      NULL,
      114.449752,
      126,
      ' 5-13-1997',
      NULL,
      NULL,
      14,
      17,
      73.887823,
      NULL,
      ' 6- 4-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.718619,
      2.928169,
      11.385789,
      0.717866,
      8,
      1,
      ' 7- 8-1993',
      0,
      0.673059,
      139,
      0.341443,
      0.901783,
      NULL,
      1.034599,
      1,
      61,
      NULL,
      NULL,
      NULL,
      ' 8-10-1997',
      63.311798,
      NULL,
      62,
      43.252775,
      54,
      19.517026,
      0,
      38,
      38.960385,
      23,
      57.577212,
      NULL,
      ' 6- 4-1989',
      24,
      5,
      18.711044,
      22,
      43.760787,
      44.170743,
      NULL,
      ' 9-24-1991',
      NULL,
      11,
      ' 0-21-1983',
      3.275352,
      6.489818,
      10.414554,
      12.157352,
      0,
      3,
      0,
      5,
      1.702953,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.646312,
      1.074659,
      NULL,
      ' 0-13-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      125.206121,
      3.855431,
      '11- 1-1986',
      NULL,
      NULL,
      NULL,
      51,
      ' 7-28-1991',
      22.860477,
      ' 2-24-1974',
      NULL,
      3.413623,
      ' 7-21-1980',
      11.507707,
      112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      ' 3-20-1997',
      NULL,
      NULL,
      43.183525,
      ' 1- 0-1997',
      1.441641,
      39,
      ' 1-12-1993',
      11.951356,
      17.235917,
      21,
      12,
      ' 7-29-1983',
      6,
      0.776007,
      127,
      ' 1-16-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


