set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9901901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '0',
      '1',
      NULL,
      '0',
      '3',
      '4',
      '1',
      '4',
      NULL,
      '0',
      NULL,
      '2',
      '4',
      NULL,
      '0',
      '1',
      '0',
      '1',
      '4',
      '0',
      '0',
      NULL,
      '',
      '1',
      '',
      '1',
      '0',
      NULL,
      '0',
      '1',
      '',
      NULL,
      '2',
      '2',
      '4',
      '1',
      '0',
      '1',
      '2',
      '1',
      '0',
      '2',
      '0',
      '420',
      '32122002',
      NULL,
      52,
      '0312332',
      NULL,
      1.001284,
      0,
      0,
      NULL,
      3.165872,
      '10- 8-1981',
      NULL,
      104,
      117,
      15.733435,
      0.749239,
      20.423178,
      NULL,
      94.642564,
      6.294209,
      19.307919,
      13.295677,
      NULL,
      NULL,
      36,
      6,
      16,
      3.743268,
      8.366323,
      8.054306,
      NULL,
      NULL,
      41.498707,
      10,
      34.997164,
      17,
      1,
      43,
      101.847289,
      69.894068,
      132,
      109.280830,
      30,
      ' 9-27-1975',
      62,
      3,
      34.399655,
      1,
      3,
      NULL,
      ' 8- 4-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      63.834520,
      14,
      21.853694,
      NULL,
      0.226616,
      ' 9-21-1991',
      0.902127,
      1.759140,
      173.633998,
      3,
      0.712308,
      70,
      0,
      0.611611,
      113.485940,
      NULL,
      NULL,
      NULL,
      ' 2-26-2001',
      14.556817,
      47,
      85.228988,
      78.974623,
      76,
      31,
      2.377779,
      25,
      16.935195,
      2.780513,
      52,
      9.133714,
      ' 7-13-1977',
      2.646692,
      NULL,
      NULL,
      0.135249,
      NULL,
      132.373778,
      NULL,
      ' 3-10-1987',
      NULL,
      NULL,
      ' 8- 6-1990',
      1.370355,
      9.789257,
      NULL,
      0,
      18,
      2,
      0,
      2.250501,
      0,
      NULL,
      0.012716,
      0,
      8.189240,
      1.683223,
      2.092114,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.241806,
      NULL,
      ' 3-11-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-23-2002',
      21.371490,
      ' 4- 5-1999',
      1,
      2.153314,
      ' 3- 2-1999',
      14.940706,
      17.628983,
      '10-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6.807015,
      ' 6-27-1990',
      0.841922,
      51,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


