set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3121',
      '14431312',
      '21400031',
      '31311413',
      NULL,
      NULL,
      '40222423',
      NULL,
      '23412010',
      '24324233',
      '33313212',
      NULL,
      '11123214',
      '40310113',
      '10040222',
      '40111402',
      '12404440',
      NULL,
      NULL,
      '44433242',
      '40223142',
      NULL,
      NULL,
      '14142314',
      '44442431',
      '14141323',
      '40412302',
      '11140443',
      '32330302',
      '10312033',
      '42321004',
      '10024203',
      NULL,
      NULL,
      NULL,
      '40440124',
      '33103112',
      '44123330',
      '11204212',
      '31111030',
      '23322101',
      '23410220',
      '31243112',
      '13214332',
      '43442230',
      '403',
      '04',
      4.378413,
      NULL,
      '1400301',
      2,
      NULL,
      3,
      NULL,
      '434404',
      3,
      ' 1-26-1993',
      ' 0-22-1987',
      62,
      NULL,
      7,
      10.414276,
      12,
      8.612204,
      83.377964,
      16,
      11.836617,
      0,
      16.414992,
      8,
      11,
      NULL,
      16,
      NULL,
      10,
      8.999264,
      8.529830,
      10.129724,
      1,
      9.030561,
      79,
      NULL,
      1,
      102,
      87.970517,
      60.581471,
      108.407485,
      63.121663,
      1,
      ' 8- 5-1983',
      NULL,
      NULL,
      32.685088,
      5.943921,
      NULL,
      130.523830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.260133,
      NULL,
      12.508295,
      9.850670,
      17,
      5.091114,
      ' 7-21-1977',
      1.257843,
      0.596651,
      256.205547,
      NULL,
      0.604999,
      75,
      1.807090,
      0.324430,
      17.133495,
      NULL,
      NULL,
      NULL,
      ' 9-15-1993',
      73.751651,
      83.378112,
      73.776445,
      81.164913,
      96.342579,
      27,
      19,
      74.624665,
      NULL,
      38,
      NULL,
      NULL,
      ' 4-20-1984',
      6.578285,
      13.836041,
      24,
      12,
      23.067331,
      13.526158,
      11.581623,
      '11- 2-1994',
      NULL,
      10.157189,
      ' 2-29-1981',
      NULL,
      7.213707,
      5.719540,
      NULL,
      0,
      5.483758,
      NULL,
      18.359166,
      NULL,
      42,
      1,
      9,
      2,
      15.709851,
      5,
      0,
      0.332226,
      0.753516,
      ' 1-23-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      117,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      '10-16-1993',
      1,
      '10-11-1998',
      7,
      NULL,
      ' 3- 8-1997',
      91,
      NULL,
      ' 4-10-1989',
      2.621332,
      1.657769,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      28,
      NULL,
      NULL,
      12.888087,
      NULL,
      NULL,
      1.151094,
      109,
      ' 1-18-1987',
      NULL,
      87,
      19.609414,
      NULL,
      ' 6- 3-1991',
      19,
      1.090627,
      111,
      ' 7-15-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


