set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2143',
      NULL,
      '14412440',
      NULL,
      '42244240',
      '10033020',
      NULL,
      '12001201',
      '33103403',
      '04024321',
      '20004403',
      '04313032',
      '23114013',
      '10300133',
      '22302304',
      '00242400',
      NULL,
      '42404332',
      '43103332',
      '20220012',
      '02303314',
      '01203400',
      '03323402',
      '22443411',
      NULL,
      NULL,
      '11203432',
      NULL,
      NULL,
      '00333432',
      '10201131',
      NULL,
      '14430211',
      '11341424',
      '14124304',
      '30030000',
      '21034322',
      '43301200',
      '21102044',
      '02043004',
      '04101021',
      '00114342',
      '14321242',
      '12110203',
      '23034024',
      '213',
      '04',
      22,
      13.718435,
      '0111444',
      NULL,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-20-1985',
      39,
      80,
      4.758880,
      19,
      2,
      9.719921,
      NULL,
      5.457432,
      NULL,
      NULL,
      46,
      NULL,
      39,
      2,
      4.472799,
      14.399485,
      5,
      12.460044,
      65,
      17,
      8,
      2.879687,
      59.934471,
      1.925766,
      NULL,
      69.312422,
      NULL,
      66.633523,
      19.096949,
      78.167122,
      NULL,
      ' 3- 9-1979',
      11.935267,
      9,
      24,
      40,
      100,
      87.787278,
      ' 1- 3-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99,
      NULL,
      6.330069,
      3,
      10,
      NULL,
      ' 2- 9-1986',
      1.841862,
      NULL,
      198.117369,
      1.217943,
      6,
      23,
      0.878921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1982',
      102.351359,
      85.511488,
      36,
      76,
      28.893910,
      103.767904,
      37.429661,
      55,
      78,
      89.333152,
      47,
      105,
      NULL,
      8.329745,
      40.684922,
      NULL,
      78,
      21,
      24,
      2,
      '10-15-1994',
      7.234481,
      25,
      ' 0-13-1998',
      NULL,
      0,
      12,
      22.499244,
      NULL,
      NULL,
      0.625710,
      14.022891,
      1.451946,
      38.051363,
      0.097916,
      NULL,
      NULL,
      24,
      0,
      1,
      NULL,
      NULL,
      ' 6- 5-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      131.330007,
      7.867913,
      ' 2-23-2003',
      NULL,
      NULL,
      NULL,
      20,
      ' 4-19-1995',
      NULL,
      ' 9- 2-1975',
      8.727299,
      5,
      NULL,
      NULL,
      98,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.471629,
      ' 7- 2-1991',
      69.592942,
      41,
      NULL,
      NULL,
      0.732988,
      84.696353,
      ' 5-29-1985',
      14,
      109.413927,
      6.305318,
      NULL,
      ' 1-25-1979',
      53,
      0.168889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


