set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '0',
      '2',
      '0',
      '3',
      NULL,
      '1',
      '0',
      '0',
      '4',
      NULL,
      '1',
      NULL,
      '1',
      '3',
      '4',
      '4',
      '1',
      '3',
      '1',
      '4',
      NULL,
      '1',
      '',
      '1',
      '',
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '4',
      '0',
      NULL,
      '4',
      '4',
      '2',
      '0',
      '0',
      NULL,
      NULL,
      '1',
      '330',
      '24332011',
      49,
      23,
      '1402132',
      0,
      NULL,
      0,
      NULL,
      '324134',
      5.458871,
      ' 2-17-1978',
      '11- 3-1989',
      9.187464,
      242,
      NULL,
      1,
      0.071232,
      4.858807,
      NULL,
      9,
      1.255922,
      2,
      14,
      1,
      NULL,
      2.750524,
      19.293550,
      19.729668,
      NULL,
      10,
      NULL,
      18.713604,
      0,
      18,
      20.403507,
      15,
      NULL,
      25,
      75,
      27.682984,
      NULL,
      70,
      NULL,
      ' 1-13-1994',
      NULL,
      6,
      19,
      5,
      19,
      215.456621,
      ' 7-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      106.229824,
      5.902041,
      NULL,
      7,
      2,
      2,
      ' 8-13-1975',
      0,
      NULL,
      NULL,
      0.039404,
      0,
      130.568537,
      1.882868,
      0,
      89,
      NULL,
      NULL,
      NULL,
      ' 4-12-1995',
      31,
      NULL,
      46,
      10,
      68.774231,
      44,
      NULL,
      24.140086,
      36,
      55.767438,
      58,
      40.953705,
      '10-18-1975',
      22.953504,
      11.474791,
      17,
      NULL,
      81.189181,
      92,
      2.268687,
      ' 0- 8-1998',
      25.083080,
      42.348740,
      ' 7-22-1993',
      10,
      2,
      0,
      14.933167,
      16,
      9,
      1.984256,
      3.478998,
      0,
      137.981595,
      1.250980,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      ' 6-13-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      142,
      11.746141,
      ' 6- 4-1994',
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      42.281668,
      ' 8- 9-1978',
      NULL,
      20,
      ' 3-21-1985',
      117,
      77,
      ' 5-26-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9,
      NULL,
      NULL,
      27.253198,
      4,
      ' 9- 1-1986',
      NULL,
      99.805712,
      ' 8-27-1995',
      9.607206,
      9,
      NULL,
      NULL,
      ' 4- 7-1985',
      23,
      1,
      92.893499,
      ' 5-23-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


