set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '4',
      '2',
      '3',
      '2',
      NULL,
      NULL,
      '1',
      '3',
      '2',
      NULL,
      NULL,
      '0',
      '2',
      '1',
      NULL,
      '4',
      NULL,
      '3',
      '3',
      '0',
      NULL,
      '1',
      '',
      '3',
      NULL,
      '3',
      '4',
      '3',
      '3',
      NULL,
      '',
      '',
      '3',
      '4',
      '2',
      NULL,
      '2',
      '1',
      '0',
      '3',
      '4',
      '4',
      '0',
      '243',
      '11321124',
      NULL,
      14,
      '0402303',
      0.222902,
      185,
      2,
      1,
      NULL,
      2,
      ' 6- 9-1992',
      ' 9- 5-1984',
      72,
      NULL,
      NULL,
      7.941946,
      NULL,
      12,
      92.206706,
      NULL,
      21,
      1,
      38.038974,
      6.193650,
      46,
      16,
      7,
      NULL,
      29.799155,
      22,
      19.946740,
      2,
      13.664312,
      NULL,
      94,
      24,
      NULL,
      NULL,
      94.003774,
      65,
      76.902076,
      NULL,
      0.133813,
      NULL,
      50.851403,
      2.958399,
      17,
      34,
      97.278136,
      NULL,
      ' 5-10-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.503253,
      11.675942,
      1.181067,
      0.611166,
      2.110018,
      9.649871,
      ' 5- 6-1994',
      0,
      0.925464,
      18,
      0,
      0,
      3,
      0.131825,
      0,
      9.726958,
      NULL,
      NULL,
      NULL,
      ' 5- 7-1991',
      6,
      27,
      2.336836,
      9,
      102,
      94,
      92,
      45.148718,
      19,
      19.412357,
      NULL,
      31.154864,
      ' 9-18-2002',
      15,
      NULL,
      NULL,
      79.775516,
      NULL,
      118,
      8.551331,
      NULL,
      33.669360,
      7,
      '10-14-1992',
      15,
      NULL,
      20,
      18.540480,
      18.231534,
      10.352255,
      1,
      15,
      0.701675,
      73,
      0,
      0,
      1.782993,
      22,
      0.941899,
      NULL,
      1.767749,
      1,
      ' 7- 3-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.129484,
      NULL,
      NULL,
      NULL,
      NULL,
      20.342015,
      ' 1- 2-1987',
      6.023667,
      NULL,
      11.606095,
      11.372663,
      NULL,
      78.579642,
      0,
      '10-25-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.334258,
      NULL,
      38.717409,
      21,
      8.260193,
      ' 3-14-2001',
      1.104446,
      47,
      ' 3- 8-1986',
      14.207450,
      19.993476,
      1,
      25.164009,
      ' 9-29-2000',
      58,
      1,
      NULL,
      ' 6-14-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


