set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7317977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3031',
      '24344301',
      NULL,
      '20231410',
      '10321331',
      NULL,
      '33003330',
      '10033033',
      '12214323',
      NULL,
      '40310211',
      '31211314',
      '04321223',
      '11230423',
      '43420240',
      NULL,
      '20344120',
      '03231231',
      '40313022',
      '21222322',
      NULL,
      '43043304',
      '03312103',
      '12430341',
      '34024000',
      '31141414',
      '31341120',
      '10303302',
      '01121013',
      NULL,
      '14402401',
      NULL,
      NULL,
      '13211421',
      '41322221',
      '14444334',
      '43444240',
      '34014231',
      '13234444',
      '41031133',
      '22101004',
      '03403411',
      '23432222',
      '43020403',
      NULL,
      '311',
      '13',
      NULL,
      NULL,
      '3411244',
      NULL,
      NULL,
      1,
      NULL,
      '040434',
      NULL,
      ' 5- 8-1983',
      ' 8-25-1999',
      37,
      NULL,
      11.212138,
      6.381546,
      9,
      13,
      49,
      NULL,
      11.936950,
      17,
      23,
      6.648009,
      6.068132,
      16,
      20.169316,
      8,
      13.124732,
      0,
      2.999816,
      NULL,
      33.222962,
      NULL,
      2,
      0.307522,
      1.763846,
      110,
      0.344670,
      29,
      86.414230,
      117,
      7.023979,
      ' 9-20-1994',
      11,
      11.046238,
      5,
      14.088285,
      108,
      NULL,
      ' 3- 5-1982',
      NULL,
      NULL,
      0.011706,
      1,
      1.769388,
      NULL,
      5,
      1,
      1.695715,
      NULL,
      0.875485,
      0,
      0.772892,
      1,
      0,
      1.181823,
      1,
      0,
      1.332872,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1984',
      57.626708,
      54,
      18.087214,
      12.897049,
      11,
      2.274886,
      ' 0- 5-1982',
      0,
      0.597754,
      NULL,
      0,
      1,
      57,
      0.791710,
      3.805366,
      44.866020,
      NULL,
      NULL,
      NULL,
      ' 8-26-1992',
      71.127746,
      76.747637,
      28,
      22.260460,
      NULL,
      NULL,
      80,
      35.291858,
      31,
      NULL,
      59,
      35,
      ' 8- 8-2002',
      NULL,
      16.164811,
      5,
      83.438155,
      74,
      110.785175,
      NULL,
      ' 9-27-1989',
      25.903599,
      19,
      NULL,
      NULL,
      8.626552,
      NULL,
      2.566466,
      NULL,
      13,
      0,
      NULL,
      NULL,
      27.727810,
      NULL,
      0.119336,
      2,
      5.462436,
      1,
      0,
      3,
      0,
      NULL,
      0.424977,
      1.007802,
      NULL,
      ' 4-26-2003',
      147,
      7.666744,
      ' 1- 6-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      '10-26-1994',
      22.347899,
      '10-20-1985',
      10.625874,
      3,
      ' 7- 8-1987',
      9,
      47,
      ' 1- 6-1977',
      6.439641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      69.163023,
      24.111601,
      40,
      NULL,
      1,
      NULL,
      NULL,
      14.622514,
      33.436689,
      16.793382,
      NULL,
      ' 9- 1-2001',
      NULL,
      NULL,
      NULL,
      ' 4- 8-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8);
commit;
end;
/


