set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7317977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4000',
      '23444333',
      '23312010',
      '34210043',
      '23214411',
      '04101143',
      '10101430',
      NULL,
      '31342442',
      '10042013',
      NULL,
      '41232223',
      '30243030',
      NULL,
      NULL,
      '03313240',
      '02211041',
      '00103344',
      '31014400',
      NULL,
      '13013041',
      '12020111',
      '31010313',
      '11140430',
      NULL,
      '02422213',
      '32201310',
      NULL,
      '33010300',
      NULL,
      '43114110',
      '20214014',
      '01411110',
      '34230421',
      NULL,
      '40341202',
      '32031222',
      '34303441',
      '20304040',
      '12341131',
      NULL,
      '33221000',
      '41340402',
      '42344302',
      '42332223',
      '022',
      '12',
      NULL,
      NULL,
      '1211142',
      2.321854,
      NULL,
      1,
      NULL,
      '100102',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      7,
      13.612230,
      11,
      29,
      2.584644,
      NULL,
      17.702868,
      6.875182,
      NULL,
      27.659962,
      12,
      11.701038,
      5,
      3.657077,
      14,
      NULL,
      8.167501,
      59.364633,
      18,
      37,
      15.347139,
      0,
      70,
      114,
      29,
      11.169244,
      NULL,
      95.859908,
      NULL,
      36.775503,
      6.871065,
      9,
      18,
      125,
      186.658222,
      '10-11-1996',
      3.375786,
      NULL,
      1.915792,
      0.886307,
      0,
      0,
      0.521733,
      0.797322,
      0,
      0,
      1,
      0.610599,
      NULL,
      0,
      0.858923,
      1,
      1.351882,
      0.172286,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-14-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620810,
      1,
      31.362729,
      0.345347,
      NULL,
      140.702310,
      NULL,
      1.818963,
      12.077576,
      NULL,
      NULL,
      NULL,
      ' 3- 3-1980',
      NULL,
      53.225014,
      70.412588,
      NULL,
      77,
      NULL,
      27.588559,
      NULL,
      70.879874,
      NULL,
      27.618238,
      NULL,
      ' 7-23-1978',
      17.919492,
      NULL,
      0,
      51,
      22.774329,
      NULL,
      5.718087,
      ' 8-17-1989',
      9.935999,
      6,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      14.372515,
      5,
      0.171572,
      2,
      0,
      1,
      3.103631,
      0,
      5.095685,
      23,
      6.870164,
      NULL,
      2.128355,
      3,
      '11-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      110.530603,
      2,
      ' 6-26-1987',
      NULL,
      NULL,
      NULL,
      19,
      ' 6- 0-1983',
      26,
      ' 3-22-1984',
      NULL,
      0,
      ' 5- 1-2003',
      NULL,
      36.937332,
      ' 6- 3-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      '11-17-1992',
      73,
      33.854689,
      27.773099,
      ' 5- 5-1998',
      1,
      17.529530,
      '10- 9-1993',
      5.251819,
      12.871520,
      NULL,
      23.606487,
      ' 0-27-1993',
      65.386911,
      NULL,
      9,
      ' 3-20-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


