set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005316';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2412',
      '32142202',
      '12231331',
      NULL,
      '20220004',
      '44340043',
      '24211331',
      NULL,
      '33322231',
      '10102304',
      '23311030',
      '41421344',
      '04200033',
      NULL,
      '24024201',
      '02042401',
      '01124140',
      '41103014',
      '31102201',
      '03230202',
      '33211334',
      '23143240',
      '22241404',
      NULL,
      '22223402',
      '33422304',
      '33140242',
      '30204342',
      NULL,
      NULL,
      '23333003',
      '32134200',
      '03222001',
      '21132103',
      '44132311',
      '13400310',
      '41143220',
      '12320411',
      '22020211',
      NULL,
      '24401400',
      NULL,
      '43441312',
      '24100114',
      '24133333',
      '',
      '',
      NULL,
      NULL,
      '1330111',
      0.310531,
      0.661875,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-25-1996',
      ' 7-25-2002',
      1.441877,
      NULL,
      37.869094,
      21,
      19,
      0.409756,
      94,
      12,
      27,
      3.254917,
      49.652710,
      29.380655,
      29,
      1.295975,
      NULL,
      0.616797,
      1,
      2.947084,
      51,
      8,
      NULL,
      21,
      NULL,
      6,
      NULL,
      106,
      13,
      63,
      43,
      76,
      91,
      ' 2-16-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735210,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 8-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      105.555266,
      NULL,
      48.277155,
      NULL,
      124,
      47.663484,
      134.353904,
      63.296821,
      109,
      46,
      6.379213,
      ' 6- 3-1981',
      21,
      30,
      21.243055,
      NULL,
      85,
      106.187323,
      NULL,
      ' 2- 8-1991',
      NULL,
      18,
      ' 2-29-1999',
      5,
      10,
      23.752719,
      NULL,
      2.576951,
      11.693451,
      NULL,
      12.630280,
      NULL,
      30,
      1.924705,
      9.841171,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-28-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      18.852089,
      ' 4-18-1993',
      0,
      34.001242,
      12.707185,
      72.253298,
      ' 1-18-1994',
      43,
      1.412303,
      NULL,
      ' 7- 3-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.344732,
      NULL,
      22,
      77.617289,
      9,
      9,
      7.662502,
      5.482643,
      12.392749,
      71.959675,
      1.286176,
      1.969620,
      37.380628,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      10.203624,
      1,
      0,
      12.830956,
      32,
      4,
      48.162972,
      1,
      NULL,
      NULL,
      0.943462,
      0.029962,
      1.773287,
      1,
      1.811201,
      25.041172,
      42,
      NULL,
      11.792279,
      48.284307,
      22.865488,
      1.141407,
      1.052709,
      NULL,
      1,
      1,
      0,
      11,
      NULL,
      39.853518,
      NULL,
      62,
      0,
      3.030731,
      NULL,
      16.735506,
      6,
      2,
      34.068984,
      NULL,
      NULL,
      NULL,
      14.126367,
      2.477490,
      NULL,
      1.238972,
      NULL,
      0,
      0.388027,
      1.999991,
      76.283619,
      ' 9-29-1988',
      ' 2-16-2001',
      ' 6-28-1991',
      ' 7- 2-1981',
      ' 9- 7-1986',
      NULL,
      '11-25-1981',
      NULL);
commit;
end;
/


