set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2001',
      '30233410',
      '31034210',
      '04001224',
      '33000141',
      '10222203',
      '12204323',
      '00042200',
      '22114024',
      NULL,
      '02314113',
      '43240324',
      '20440242',
      '02243303',
      '20320223',
      '40104003',
      NULL,
      '10130312',
      NULL,
      '02413234',
      '24004423',
      '40324211',
      NULL,
      '13244033',
      NULL,
      NULL,
      NULL,
      '04400034',
      NULL,
      '00430442',
      '40001201',
      NULL,
      '11410203',
      NULL,
      '41000230',
      '40212404',
      '23111312',
      '13432204',
      '24131043',
      '23413343',
      '01410342',
      NULL,
      NULL,
      '22334103',
      NULL,
      '021',
      '13',
      NULL,
      12.192273,
      '4402044',
      2.209720,
      1,
      1,
      NULL,
      '034414',
      5,
      NULL,
      ' 1-27-1998',
      3.914599,
      50.238372,
      6,
      0.979128,
      6,
      1.805208,
      19,
      0.291513,
      1,
      NULL,
      10.946219,
      9,
      NULL,
      NULL,
      8.713161,
      1.148183,
      1.876314,
      4.942514,
      NULL,
      5.035224,
      9,
      3.603460,
      54.468458,
      1,
      NULL,
      23.007510,
      NULL,
      10,
      79.353469,
      112,
      30,
      NULL,
      NULL,
      1.975033,
      22,
      NULL,
      NULL,
      65.427247,
      ' 7-14-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141467,
      0.682027,
      NULL,
      7.981925,
      0.307563,
      NULL,
      1.422029,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-25-1976',
      NULL,
      21,
      30,
      10.276786,
      13.060143,
      27.836524,
      14,
      NULL,
      6.763236,
      12,
      NULL,
      1,
      ' 4-24-1982',
      13,
      2.642117,
      NULL,
      28,
      13.775976,
      2.617694,
      NULL,
      NULL,
      1.201553,
      NULL,
      ' 6-28-1974',
      1,
      8,
      0,
      12,
      11.973308,
      2,
      1.170725,
      0,
      1.223457,
      40,
      0.995836,
      0.379008,
      2,
      10.200025,
      3.933853,
      0.546071,
      NULL,
      NULL,
      ' 3- 4-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.096799,
      '11-24-1991',
      3.057384,
      13.327387,
      '10-17-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.962759,
      ' 4-28-1974',
      1.860238,
      7.240687,
      8.548958,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      51.425016,
      2,
      50.374061,
      ' 4- 6-1978',
      16,
      1.765299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


