set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      NULL,
      '2',
      '0',
      '0',
      '4',
      '0',
      '1',
      NULL,
      '4',
      '3',
      NULL,
      '0',
      '4',
      '3',
      '3',
      '',
      NULL,
      NULL,
      '2',
      '2',
      '1',
      '3',
      '4',
      NULL,
      '',
      '3',
      '3',
      '0',
      NULL,
      '0',
      '0',
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '132',
      NULL,
      4.077567,
      20,
      '0113343',
      NULL,
      43,
      3,
      NULL,
      NULL,
      3,
      ' 2- 9-1988',
      ' 7- 2-1996',
      60.583525,
      227.927837,
      13,
      NULL,
      1,
      5.677909,
      33.368615,
      5,
      13,
      11.499713,
      7.402992,
      NULL,
      13,
      5.406362,
      2.371722,
      0.904658,
      4,
      NULL,
      14.698855,
      11.168786,
      42,
      NULL,
      5.995952,
      10,
      1,
      NULL,
      NULL,
      39,
      130,
      NULL,
      56,
      ' 7-24-1990',
      26.942835,
      16.354208,
      20.273629,
      19,
      12,
      32,
      ' 6-22-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      24.707956,
      39,
      10.867256,
      0,
      '10-16-2000',
      NULL,
      0.649030,
      36.856036,
      1.407050,
      1.768563,
      9.920738,
      1,
      NULL,
      21.061013,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1978',
      17,
      NULL,
      36,
      NULL,
      NULL,
      7.634364,
      27,
      7.329406,
      35.290843,
      1.235136,
      24.407784,
      6,
      ' 4-21-1985',
      NULL,
      10,
      6,
      41.023461,
      69,
      9.994033,
      1,
      NULL,
      7.592525,
      6,
      ' 4- 8-2001',
      8.153831,
      NULL,
      8.369120,
      12.094857,
      6,
      3,
      1.848373,
      3.132444,
      1.123691,
      8,
      1.012998,
      NULL,
      0,
      2,
      3,
      9,
      NULL,
      1.101871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218159,
      ' 2-28-1977',
      39.596468,
      ' 1- 8-2001',
      5.846550,
      12.136195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      ' 2-16-1985',
      21.757640,
      4,
      NULL,
      '10-18-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.848406,
      NULL,
      ' 2-11-1979',
      28.523180,
      0,
      NULL,
      ' 4-19-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


