set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '4',
      NULL,
      '0',
      '4',
      '2',
      '0',
      '0',
      '1',
      '4',
      '2',
      '0',
      '1',
      '0',
      '3',
      '0',
      NULL,
      NULL,
      '0',
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      '2',
      '',
      '1',
      NULL,
      '2',
      '3',
      '4',
      '',
      '',
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '1',
      '0',
      '0',
      NULL,
      '0',
      '4',
      '340',
      '12030233',
      58.762041,
      43,
      '4432120',
      NULL,
      89,
      0,
      1,
      '443021',
      1.051891,
      ' 2-17-1977',
      ' 3- 4-1999',
      59,
      170.082145,
      4,
      NULL,
      NULL,
      3.221119,
      19,
      9,
      6,
      4,
      27,
      2.989727,
      NULL,
      17.351290,
      NULL,
      8,
      3.497559,
      11.325718,
      NULL,
      NULL,
      13.039336,
      14,
      27.627880,
      7,
      0,
      2,
      NULL,
      NULL,
      0,
      121,
      163,
      ' 4-25-1977',
      24.245238,
      11.320036,
      24.985350,
      2,
      NULL,
      147,
      '11-19-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.990454,
      20,
      NULL,
      19.039292,
      12,
      1.276917,
      NULL,
      0.778565,
      1,
      126.178541,
      NULL,
      2,
      53.851294,
      NULL,
      0.280116,
      35,
      NULL,
      NULL,
      NULL,
      ' 4-24-1975',
      20,
      26.666387,
      20.684007,
      6.755604,
      51.900260,
      10.244764,
      62,
      10,
      10.075255,
      11.253635,
      44,
      17,
      ' 2- 3-1977',
      5.895807,
      6,
      11,
      NULL,
      18,
      18,
      8.215118,
      NULL,
      6,
      NULL,
      ' 6- 4-1981',
      NULL,
      5.043790,
      0,
      NULL,
      15,
      1.354236,
      3.491564,
      4.628137,
      0,
      NULL,
      3,
      0,
      0.504560,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.962364,
      ' 8-11-2001',
      NULL,
      '10- 7-2001',
      NULL,
      11.909171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      12.272117,
      ' 1-22-1998',
      17.538553,
      23,
      NULL,
      ' 2- 1-1978',
      NULL,
      NULL,
      NULL,
      1.602172,
      16,
      14,
      67.922399,
      ' 4- 0-1975',
      12,
      1,
      177.433553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


