set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8612313';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4440',
      '22413113',
      '44432120',
      '22314203',
      '13441313',
      '33234331',
      NULL,
      '42221201',
      '12040011',
      '24320231',
      '32021030',
      NULL,
      '23110142',
      '02213442',
      NULL,
      '44420032',
      '02421441',
      '23430023',
      NULL,
      '30041423',
      '02000012',
      '22121000',
      '33033304',
      '23210231',
      '21134211',
      '11411112',
      NULL,
      '14031112',
      '22103412',
      '43433012',
      '24221200',
      '33102401',
      '01230213',
      '01312300',
      '03210022',
      '13311441',
      NULL,
      '30040242',
      '21234202',
      '23403422',
      '11003113',
      '30204032',
      NULL,
      NULL,
      '24033222',
      '304',
      '11',
      NULL,
      NULL,
      NULL,
      NULL,
      1.910149,
      2,
      NULL,
      '131023',
      5,
      ' 6- 8-2000',
      ' 2-15-1985',
      10.356901,
      NULL,
      NULL,
      NULL,
      20,
      15.167576,
      38.809719,
      0.408834,
      12.526783,
      1,
      22.578331,
      12.365442,
      15,
      19.520487,
      3,
      NULL,
      18,
      6.636058,
      52.163762,
      18,
      NULL,
      26,
      76.458110,
      10,
      0,
      NULL,
      53.976699,
      NULL,
      88.152681,
      132.212789,
      95,
      ' 8- 3-1987',
      7.481290,
      9,
      6.648758,
      18,
      94.777746,
      95,
      '11-11-1995',
      0,
      0,
      0,
      2,
      4.050868,
      1.927601,
      3,
      1,
      NULL,
      1.078451,
      NULL,
      0,
      1.872228,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.734686,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1983',
      4,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 2-10-2000',
      0.474335,
      0.368426,
      81,
      1,
      0,
      NULL,
      NULL,
      1.452280,
      NULL,
      0.977194,
      0.167991,
      135,
      ' 8-27-1985',
      75.816270,
      NULL,
      48,
      42.930410,
      22,
      52,
      91.720584,
      71,
      NULL,
      NULL,
      NULL,
      50,
      '11-20-1977',
      16.430282,
      NULL,
      13.509611,
      11.877715,
      42,
      NULL,
      NULL,
      ' 0-29-1985',
      12.700547,
      19,
      ' 8-26-1975',
      9.107563,
      12.787959,
      5,
      3,
      7,
      NULL,
      1.221907,
      4.812874,
      0,
      86.552370,
      NULL,
      2.978748,
      NULL,
      5,
      7.740338,
      1.932912,
      3,
      0.227162,
      ' 0-16-1981',
      NULL,
      0.278901,
      0,
      NULL,
      7,
      17,
      ' 3-10-1977',
      21,
      NULL,
      ' 0-19-1998',
      NULL,
      NULL,
      3.980110,
      ' 0-22-1979',
      NULL,
      0,
      '11- 2-2000',
      22.153458,
      127,
      ' 9- 3-1984',
      4,
      10.671129,
      '10-19-2002',
      NULL,
      2.509680,
      '11-23-2003',
      1,
      0,
      NULL,
      ' 4- 6-1990',
      49,
      0,
      6.687146,
      ' 9- 9-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3);
commit;
end;
/


