set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9751565';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '0',
      '0',
      '2',
      '1',
      '1',
      NULL,
      '4',
      '2',
      '1',
      '3',
      NULL,
      '4',
      '3',
      '0',
      '2',
      NULL,
      '2',
      '1',
      '0',
      NULL,
      '2',
      '2',
      '',
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      '0',
      '4',
      '',
      NULL,
      '3',
      NULL,
      '2',
      NULL,
      '3',
      '4',
      NULL,
      '1',
      '4',
      '2',
      '4',
      '204',
      '13400221',
      27,
      4,
      '1122233',
      3.582194,
      0,
      2,
      NULL,
      NULL,
      1.166325,
      ' 4-22-2000',
      NULL,
      NULL,
      66.250014,
      NULL,
      NULL,
      31,
      17,
      NULL,
      20.201591,
      20,
      8,
      34.797726,
      NULL,
      29,
      2,
      35,
      27,
      17.660768,
      2.042311,
      NULL,
      9.670351,
      46,
      16.260365,
      NULL,
      26,
      0,
      30,
      48,
      91,
      NULL,
      192,
      130.638736,
      NULL,
      18,
      2,
      29,
      21,
      47,
      22.442058,
      '11-29-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      40.254309,
      NULL,
      NULL,
      13.893008,
      3,
      ' 4-14-1977',
      0.898186,
      NULL,
      NULL,
      0,
      3,
      75,
      0,
      3,
      78,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1980',
      83.634220,
      49.758118,
      42.028835,
      80,
      9.657080,
      NULL,
      96.569954,
      NULL,
      103,
      NULL,
      72,
      97,
      ' 9-25-1992',
      3,
      3,
      18.039033,
      42.599410,
      65.103057,
      17,
      6.849601,
      ' 0-15-1981',
      4,
      24.327663,
      NULL,
      NULL,
      19,
      20.102118,
      9,
      NULL,
      NULL,
      0,
      20.690655,
      1,
      27.452944,
      1,
      0,
      21.077364,
      28,
      1.236597,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      119.866344,
      9.599021,
      ' 1- 0-1995',
      NULL,
      NULL,
      NULL,
      59.642385,
      ' 1-28-1984',
      NULL,
      ' 1-20-1995',
      NULL,
      3,
      ' 0- 1-1992',
      74,
      80.166712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      ' 0- 5-2000',
      49.587479,
      45.581153,
      22,
      NULL,
      1,
      40,
      '10-29-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


