set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6803034';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34101011',
      NULL,
      '13323410',
      '31241031',
      '01400420',
      '40333404',
      NULL,
      '41201022',
      NULL,
      '34230431',
      '31313010',
      NULL,
      '04124212',
      NULL,
      '34124321',
      '01014441',
      '24422040',
      '44143032',
      '23230134',
      '31234420',
      '13123234',
      '23320440',
      '43143330',
      '24430201',
      '00210041',
      '32320200',
      '23014210',
      '44002303',
      NULL,
      '12103302',
      '01234301',
      '21440221',
      '23310304',
      NULL,
      NULL,
      '21211124',
      NULL,
      '32042324',
      '30043134',
      '41232400',
      '34102102',
      NULL,
      '42412043',
      '44423303',
      '',
      '',
      NULL,
      NULL,
      '0411011',
      NULL,
      0.721537,
      2,
      NULL,
      NULL,
      0,
      ' 0-26-1975',
      ' 3- 4-1986',
      45.505795,
      NULL,
      7,
      12,
      15,
      19.841652,
      103.837108,
      NULL,
      1.592338,
      13.016885,
      31,
      15.762118,
      32.244189,
      NULL,
      10.038546,
      2,
      1.820252,
      18,
      NULL,
      17,
      NULL,
      NULL,
      95.969602,
      0,
      NULL,
      104,
      81.122894,
      51,
      8,
      108,
      195,
      ' 0-14-2002',
      NULL,
      60.975500,
      19.871607,
      9.252567,
      89,
      210.755680,
      '10- 1-1979',
      1.019834,
      1,
      1.520626,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593602,
      0,
      NULL,
      0.121128,
      NULL,
      0.565190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-22-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      NULL,
      1.215392,
      8.853060,
      15,
      83.505997,
      94.033077,
      75.024037,
      NULL,
      77.555582,
      32.758617,
      47.047302,
      ' 7-23-2003',
      15,
      11,
      12.748474,
      21.707915,
      0.978227,
      26,
      8.659688,
      ' 4-27-2003',
      20,
      28,
      ' 5-14-1997',
      17.968841,
      23,
      NULL,
      2,
      23,
      0,
      NULL,
      16,
      NULL,
      NULL,
      1,
      4.389262,
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      47.348345,
      22,
      NULL,
      1.007562,
      6.756001,
      '10-17-1987',
      9.417000,
      30,
      0,
      23.366960,
      '11-13-2003',
      22.738715,
      1.276214,
      2.160941,
      '11- 0-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      0.300981,
      NULL,
      NULL,
      NULL,
      24.488057,
      15,
      3.866960,
      8.811805,
      4.796330,
      4.328676,
      NULL,
      0,
      0.010673,
      62,
      1,
      1,
      55.636038,
      1,
      1.303702,
      6.383983,
      2.141040,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.658472,
      0.551794,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      25.164295,
      1,
      6,
      2.019274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.678805,
      3.046028,
      NULL,
      6,
      7.498923,
      5.639270,
      NULL,
      NULL,
      12,
      NULL,
      7.728801,
      1.627230,
      0.898870,
      0,
      2.091308,
      1,
      0,
      NULL,
      NULL,
      ' 8- 7-1996',
      ' 4-14-2000',
      ' 9- 5-1985',
      ' 3-29-1978',
      '10-15-2001',
      ' 3- 6-1991',
      NULL,
      NULL);
commit;
end;
/


