set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8312986';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4414',
      '04134434',
      NULL,
      '40320432',
      '13023001',
      '00021024',
      '40111114',
      '40423344',
      '30300413',
      '40104423',
      NULL,
      NULL,
      '20231143',
      '34040201',
      '04430004',
      '30024440',
      '40123213',
      '44043400',
      '43034401',
      '21042211',
      NULL,
      '14111211',
      '32031112',
      NULL,
      '00120211',
      '03401112',
      '22414001',
      '31140242',
      '20222312',
      NULL,
      NULL,
      '23130024',
      '30414130',
      '31022432',
      '40020314',
      '04324210',
      '33112120',
      '43424122',
      '03213222',
      '11321330',
      '14433234',
      '24021323',
      '21321122',
      '33310313',
      '34410234',
      '',
      '',
      NULL,
      NULL,
      NULL,
      3.939424,
      1,
      2,
      NULL,
      '332121',
      0,
      ' 2- 0-1994',
      '11-17-1995',
      11.769705,
      NULL,
      17,
      12.953343,
      3,
      2.097537,
      NULL,
      NULL,
      1,
      6,
      14.977488,
      NULL,
      18,
      8.216024,
      2,
      8.194145,
      0.313107,
      5,
      15.898939,
      4.728247,
      7,
      2,
      17,
      0,
      NULL,
      57.170841,
      58.986664,
      28,
      59,
      7,
      NULL,
      ' 6-19-1990',
      3,
      NULL,
      NULL,
      16,
      53,
      164,
      ' 5-15-2003',
      7.727548,
      1,
      14,
      11.823034,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887983,
      3,
      NULL,
      1.957152,
      0.371021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-18-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-20-1996',
      37.977797,
      84,
      84.949131,
      17,
      54.447964,
      NULL,
      NULL,
      40.717619,
      NULL,
      51,
      1,
      29.974889,
      ' 8-15-1989',
      8,
      NULL,
      18.278065,
      44.224699,
      54.961322,
      NULL,
      NULL,
      NULL,
      10.807112,
      9,
      ' 3-19-1999',
      13.927113,
      4,
      2.989332,
      2,
      NULL,
      5.994074,
      NULL,
      NULL,
      NULL,
      1,
      5.364131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-10-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.461325,
      10.280738,
      NULL,
      NULL,
      NULL,
      ' 8-10-1975',
      6,
      NULL,
      2.636466,
      NULL,
      ' 0- 3-1977',
      30,
      1,
      398.582458,
      '10-23-1976',
      NULL,
      NULL,
      NULL,
      35.744679,
      87.511050,
      86.975480,
      13.649456,
      46.640914,
      0.808454,
      29,
      43.739299,
      6,
      33,
      NULL,
      13,
      0,
      1,
      51,
      NULL,
      NULL,
      NULL,
      5.694654,
      0.423624,
      NULL,
      0,
      0,
      278,
      20,
      0.683648,
      NULL,
      0,
      17,
      0,
      1,
      1,
      4.272205,
      NULL,
      1,
      35.476464,
      43.180343,
      18.256701,
      8,
      5.391652,
      43,
      0.850244,
      0,
      2.000127,
      0.152344,
      8.812291,
      1,
      7,
      3.419087,
      33.929241,
      0,
      31.793125,
      0,
      0.125318,
      27,
      NULL,
      NULL,
      NULL,
      3,
      5.759946,
      12.677503,
      44,
      3.660045,
      14.341596,
      1.078475,
      2,
      7,
      2,
      1.069244,
      0.991875,
      5.622868,
      '11-10-1994',
      ' 9-29-1986',
      ' 9- 6-1984',
      NULL,
      ' 0- 7-1975',
      ' 3- 6-1982',
      ' 4-13-1976',
      NULL);
commit;
end;
/


