set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9749389';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '1',
      '2',
      '4',
      '1',
      '1',
      '4',
      '1',
      '3',
      '4',
      '2',
      NULL,
      NULL,
      '4',
      '0',
      '4',
      '2',
      '4',
      '1',
      '4',
      '4',
      '2',
      '3',
      '',
      NULL,
      NULL,
      '1',
      '0',
      '0',
      '1',
      '3',
      '',
      '',
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      NULL,
      '4',
      '0',
      '0',
      '3',
      '0',
      '332',
      '22434440',
      30.774778,
      22.359461,
      '1400423',
      2,
      0,
      2,
      NULL,
      '211204',
      NULL,
      '10-27-1984',
      ' 4- 2-1985',
      57.951571,
      223.225591,
      20.901598,
      16.283714,
      11.022070,
      5.705914,
      24,
      NULL,
      16.742553,
      NULL,
      22.083339,
      NULL,
      8,
      15.592982,
      21,
      9,
      12.187313,
      10,
      4.690936,
      NULL,
      8,
      NULL,
      75.813760,
      13,
      1.453316,
      27.045057,
      NULL,
      37.586510,
      86.952431,
      107.512356,
      119.724851,
      ' 4-16-1979',
      51.080801,
      NULL,
      33.111185,
      20,
      34,
      NULL,
      ' 5-29-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      55.622513,
      8,
      20.536310,
      3,
      1.961434,
      ' 4- 1-1983',
      0,
      1,
      28,
      NULL,
      1.224421,
      NULL,
      0.290482,
      0.513516,
      21,
      NULL,
      NULL,
      NULL,
      ' 8-23-1978',
      15,
      NULL,
      NULL,
      77,
      78.514840,
      52,
      48.780537,
      81.865591,
      17,
      40,
      25,
      NULL,
      '11-23-2003',
      21,
      10.254371,
      4.761853,
      NULL,
      20,
      NULL,
      11.005675,
      NULL,
      NULL,
      3,
      ' 7- 4-2000',
      1,
      8,
      NULL,
      14.728805,
      15,
      5,
      3,
      4.591478,
      0,
      51,
      1,
      1,
      16,
      NULL,
      1,
      11,
      1.809914,
      0,
      '10- 3-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      224,
      13.892883,
      ' 1- 8-1986',
      NULL,
      NULL,
      NULL,
      1.642651,
      ' 1-12-1992',
      43.278105,
      NULL,
      7.006758,
      NULL,
      ' 4-27-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      ' 6-23-1993',
      61.480010,
      NULL,
      6.538231,
      NULL,
      0.111991,
      1.183502,
      ' 9-10-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


