set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8032789';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0024',
      '32440311',
      '10211314',
      '20110302',
      '12142442',
      '04214103',
      '00102114',
      '44111131',
      '43410322',
      '43040232',
      '30222210',
      NULL,
      '14404042',
      '10412430',
      '21301222',
      '31141203',
      '31401143',
      '42440321',
      '00132000',
      '32033412',
      '24404121',
      '42121341',
      NULL,
      NULL,
      '33014243',
      '13404220',
      NULL,
      '03134430',
      '32034342',
      '04412304',
      '34203410',
      '21410112',
      '21432033',
      NULL,
      '32320441',
      NULL,
      '12033334',
      '04431402',
      '22144210',
      '23242102',
      '01303041',
      '00431422',
      NULL,
      '10200043',
      '32004340',
      NULL,
      '',
      NULL,
      NULL,
      '3403034',
      3,
      1,
      2,
      NULL,
      NULL,
      2.033958,
      '11-26-1985',
      ' 0-20-1980',
      62.674408,
      NULL,
      13,
      12,
      12.678772,
      9.808998,
      13.134175,
      2,
      17.628291,
      20.411832,
      NULL,
      NULL,
      38.200395,
      20.503117,
      NULL,
      7,
      36,
      18,
      10,
      24,
      73,
      21,
      17.867448,
      3.084416,
      NULL,
      83.335318,
      12,
      NULL,
      27,
      NULL,
      226,
      NULL,
      44,
      13,
      12,
      2,
      77,
      247,
      NULL,
      2.338763,
      0,
      4,
      5.719549,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703058,
      1.276280,
      NULL,
      0.615693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-18-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-20-1989',
      142.039073,
      52,
      33,
      16,
      101,
      23,
      140,
      105,
      112,
      15,
      58,
      6,
      ' 0- 8-1975',
      6.388826,
      27.840864,
      17.068323,
      NULL,
      59.854411,
      22.544868,
      0,
      ' 9-14-1986',
      43.490110,
      NULL,
      ' 1-22-1976',
      9.701484,
      6.322008,
      10,
      1.958666,
      19,
      13,
      NULL,
      NULL,
      NULL,
      118.652836,
      NULL,
      0.522022,
      26.076599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-13-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63.763239,
      43.639565,
      29.418099,
      ' 5-14-1988',
      0,
      NULL,
      ' 4-21-1993',
      3.121363,
      NULL,
      NULL,
      6,
      ' 7-15-1987',
      8.216876,
      3,
      23.374819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      96,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748011,
      0.174617,
      50.076363,
      NULL,
      0,
      NULL,
      1,
      NULL,
      46,
      0.875336,
      NULL,
      149.814234,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      1.726577,
      0,
      1,
      3.961610,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      23.396191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199907,
      NULL,
      1.011476,
      11,
      NULL,
      29.158338,
      19.766051,
      37.604510,
      NULL,
      NULL,
      6,
      NULL,
      6,
      5.060534,
      NULL,
      0.422580,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 5-1989',
      NULL,
      NULL,
      NULL,
      ' 6-22-1979',
      NULL,
      NULL);
commit;
end;
/


