set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6500755';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20444300',
      NULL,
      '03002122',
      '42012140',
      NULL,
      NULL,
      '34422033',
      NULL,
      '12212402',
      NULL,
      '13022441',
      '10400104',
      NULL,
      '24112230',
      '23110340',
      '21203402',
      NULL,
      '22421113',
      '04043110',
      NULL,
      '21010021',
      '43021423',
      '34320004',
      '32001022',
      NULL,
      '04344434',
      '11123334',
      '23414010',
      '00221424',
      NULL,
      NULL,
      '11312342',
      '02104130',
      '03431211',
      '14202214',
      NULL,
      '42230042',
      '40423313',
      '22414424',
      NULL,
      '02222210',
      '04324231',
      '12423301',
      '44430140',
      '330',
      '02',
      12,
      4,
      '0220034',
      0.334974,
      1.306720,
      1,
      NULL,
      NULL,
      4.074322,
      ' 3- 0-1990',
      ' 1-18-1977',
      NULL,
      79,
      35.553917,
      24.884838,
      2,
      25,
      57,
      NULL,
      NULL,
      17.418197,
      30.576125,
      19,
      34,
      9,
      17,
      14,
      NULL,
      NULL,
      58.734320,
      20.549971,
      10.226061,
      0,
      169.717669,
      10.928829,
      0,
      101.542903,
      NULL,
      26.402908,
      14.686345,
      280,
      104,
      ' 7-28-1975',
      44.576547,
      42,
      0.559598,
      36,
      183.311020,
      85.964724,
      '11-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      NULL,
      7.253979,
      14,
      24.534474,
      1,
      ' 9-26-1985',
      0.455192,
      0,
      NULL,
      1,
      NULL,
      83,
      6,
      0,
      23,
      NULL,
      NULL,
      NULL,
      ' 0- 0-1974',
      69,
      81,
      61,
      NULL,
      15,
      NULL,
      82,
      85,
      19,
      77.191039,
      NULL,
      93.694435,
      ' 3-29-1994',
      1,
      11,
      NULL,
      58.531868,
      27.665065,
      27,
      3,
      ' 6- 3-1979',
      NULL,
      NULL,
      '10-26-1984',
      11,
      11,
      13.989467,
      10,
      NULL,
      NULL,
      3.150086,
      8.871368,
      0.109136,
      86,
      1.886182,
      6.068668,
      6.529420,
      NULL,
      4.178202,
      1,
      0.576266,
      NULL,
      ' 8-19-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.266633,
      ' 9-22-1977',
      NULL,
      NULL,
      NULL,
      31.241919,
      ' 3- 2-1999',
      32,
      ' 2-11-1990',
      NULL,
      6,
      ' 8-27-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      ' 5-26-1991',
      69,
      NULL,
      15.965426,
      ' 8-28-1989',
      0.106774,
      83,
      ' 0-27-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


