set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8700949';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4420',
      '13113123',
      '31201334',
      '24043040',
      '42430430',
      '04411342',
      '10422122',
      '42422420',
      NULL,
      '24020340',
      '00200012',
      '21212243',
      NULL,
      '12042322',
      '41111242',
      '43220022',
      '31432442',
      '02443034',
      '22400200',
      NULL,
      NULL,
      NULL,
      '20203011',
      '44421243',
      '30001404',
      '14003421',
      '14031140',
      '44113024',
      '12341112',
      '20220130',
      '40300413',
      '41440223',
      '14234334',
      '02133012',
      '02213233',
      '14003124',
      '20134421',
      NULL,
      '14014144',
      '32222213',
      '13242323',
      '21020012',
      '30034400',
      '00110101',
      '11434433',
      '013',
      '13',
      22.975436,
      15,
      '2422133',
      NULL,
      1.424326,
      1,
      NULL,
      NULL,
      0.645563,
      ' 5- 5-1994',
      ' 5-15-1995',
      111,
      97.109688,
      1.874478,
      12,
      29,
      16,
      62,
      NULL,
      3,
      NULL,
      0.710512,
      NULL,
      4,
      10,
      7,
      3.423808,
      16.593703,
      7,
      7,
      3,
      21,
      0.605468,
      50,
      13,
      0,
      64.361499,
      160.707362,
      40.224694,
      20.999314,
      21,
      78.757201,
      '11- 9-2003',
      35.807787,
      9.578008,
      13,
      22.511927,
      130,
      68,
      '10- 3-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      3,
      10,
      14.647781,
      NULL,
      ' 1-22-1974',
      0,
      1,
      51.661995,
      0,
      0.423270,
      45,
      1.080175,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 4-1976',
      100.398879,
      29.681959,
      47,
      12.763048,
      70,
      52.880323,
      23.422506,
      6.140974,
      49,
      22.806632,
      NULL,
      NULL,
      ' 6-13-1996',
      5.179768,
      26,
      11.696211,
      NULL,
      NULL,
      12,
      NULL,
      '11-17-2002',
      7,
      NULL,
      ' 4-11-1989',
      NULL,
      4.392628,
      NULL,
      10.645311,
      4.571458,
      3,
      1,
      12.999444,
      1.527572,
      31,
      NULL,
      NULL,
      0.396341,
      18.418026,
      NULL,
      5,
      1,
      0.707183,
      ' 5-12-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1991',
      6,
      NULL,
      ' 4- 8-1980',
      119,
      31.166544,
      ' 4-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.891282,
      ' 7-22-1995',
      NULL,
      18,
      16.296673,
      NULL,
      1.776944,
      170,
      ' 5-20-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


