set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9236522';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01323034',
      '11430404',
      '22014002',
      '32323043',
      '24323113',
      '43330203',
      '10411134',
      NULL,
      '30134231',
      '10101301',
      '33433302',
      '24310304',
      '21404111',
      NULL,
      '03000432',
      '01423200',
      NULL,
      '21143012',
      NULL,
      '43241132',
      '13224334',
      '01100130',
      '34344100',
      NULL,
      '33021240',
      '44040122',
      '22042441',
      NULL,
      '12433000',
      '14211011',
      '31212444',
      '40142340',
      '31243420',
      '42243330',
      '12212110',
      NULL,
      '22104413',
      NULL,
      '22244413',
      '01022224',
      '12022244',
      NULL,
      '02301301',
      '33240143',
      NULL,
      '22',
      NULL,
      NULL,
      '0210324',
      NULL,
      0.245523,
      3,
      NULL,
      '440232',
      0,
      NULL,
      ' 0-29-1976',
      20,
      NULL,
      35,
      NULL,
      NULL,
      7,
      35.431243,
      9,
      7.722676,
      NULL,
      36,
      NULL,
      41,
      19.050454,
      14,
      16,
      25.898180,
      26.467724,
      89,
      8.440083,
      45,
      17,
      NULL,
      8,
      0.544363,
      NULL,
      141.945537,
      120.849636,
      35,
      NULL,
      NULL,
      ' 5-14-1987',
      42,
      25,
      25,
      NULL,
      12.293203,
      72,
      NULL,
      1,
      3.400601,
      3,
      1,
      3.882000,
      NULL,
      1,
      3.564353,
      1.146876,
      1,
      5,
      1,
      0.010400,
      0.827365,
      1,
      1.637579,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 6-1976',
      86.895540,
      25.003640,
      14,
      7.287246,
      11.136568,
      4.676465,
      ' 7- 0-2000',
      NULL,
      0,
      199,
      1,
      NULL,
      2.788566,
      NULL,
      2.804657,
      82.332159,
      1,
      1,
      217.583028,
      ' 4-12-1988',
      50.327522,
      33,
      110,
      105,
      11,
      107.339438,
      20,
      52,
      80.065266,
      74,
      60,
      NULL,
      ' 9-24-1996',
      18,
      17.131568,
      17.784797,
      77,
      54.333341,
      8.233064,
      NULL,
      ' 8-28-1986',
      13,
      13,
      ' 1-15-1978',
      12.623070,
      NULL,
      18,
      27,
      13.635303,
      9,
      1.075408,
      1.941063,
      0.468447,
      NULL,
      1.168627,
      4,
      23.944312,
      NULL,
      NULL,
      1.386579,
      0,
      1.563639,
      ' 2- 9-1992',
      7.086976,
      0,
      5.921981,
      ' 9-14-1986',
      155,
      6,
      ' 3-23-2003',
      NULL,
      4.662282,
      '11-21-1995',
      2.746636,
      ' 8-24-1990',
      37.161515,
      ' 3- 5-2001',
      15,
      12.491874,
      ' 6- 8-1991',
      83,
      32,
      ' 7-24-1992',
      NULL,
      2,
      NULL,
      6.936705,
      0.875385,
      ' 6-23-2002',
      3,
      0,
      NULL,
      ' 7-29-1979',
      58,
      34,
      3.933848,
      ' 6-12-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


