set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917132';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0231',
      NULL,
      '10100230',
      '34333412',
      '24033020',
      '13142230',
      '40034043',
      '24000342',
      '31422343',
      '30423214',
      NULL,
      '14403130',
      '12223420',
      '31233111',
      NULL,
      '11314330',
      '13330230',
      NULL,
      '02310403',
      NULL,
      '34111212',
      '01030223',
      '43400030',
      NULL,
      '30344213',
      NULL,
      '43222420',
      '14402140',
      '20134430',
      '01011423',
      '44222104',
      NULL,
      '14200442',
      NULL,
      '02333323',
      '02334022',
      '04233200',
      '00021141',
      NULL,
      '20201321',
      '10122314',
      '03041404',
      '03322433',
      '11300031',
      '23043042',
      '',
      '',
      NULL,
      NULL,
      '3241434',
      NULL,
      1,
      1,
      NULL,
      '031432',
      3,
      ' 6- 1-1995',
      ' 1-27-1996',
      23,
      NULL,
      13.003881,
      5.736566,
      4.038171,
      NULL,
      74,
      0,
      10,
      13,
      8,
      9,
      6.203446,
      NULL,
      6,
      0,
      1,
      NULL,
      9.514646,
      6.678046,
      23.930054,
      7,
      35.832946,
      1,
      NULL,
      NULL,
      NULL,
      1.254803,
      NULL,
      36.747857,
      37,
      ' 7-11-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.029908,
      1.399892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998025,
      0,
      4,
      1.553951,
      0.824008,
      3.132199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 6-1975',
      NULL,
      19.200198,
      27,
      90,
      23.566493,
      74.113486,
      3.684298,
      NULL,
      43.664224,
      61,
      18.205673,
      96,
      ' 1- 4-1975',
      5.823702,
      1,
      17.367371,
      44,
      26,
      48.173497,
      NULL,
      ' 9- 3-1999',
      NULL,
      NULL,
      ' 9- 1-1974',
      NULL,
      1,
      5,
      6.504370,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      45.133628,
      4,
      0.670554,
      0.964157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-17-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.133721,
      17.782896,
      '10- 4-1987',
      NULL,
      NULL,
      NULL,
      1.362388,
      62.214345,
      12,
      95,
      NULL,
      65.640653,
      1,
      215,
      ' 2- 3-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      103,
      200.172656,
      58.211378,
      94.822524,
      21,
      117,
      100,
      28.072009,
      38.342852,
      7,
      52.918326,
      NULL,
      2,
      95,
      NULL,
      0.928066,
      95.834295,
      1.154973,
      0,
      60,
      NULL,
      3,
      188,
      66,
      9,
      NULL,
      NULL,
      NULL,
      24.209474,
      NULL,
      NULL,
      1.021394,
      3,
      0.194694,
      NULL,
      24,
      47,
      2.092037,
      66,
      12,
      2,
      1.729445,
      9.125276,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.037806,
      18.099628,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 1-1988',
      ' 8-14-2000',
      ' 7- 1-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


