set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917132';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0113',
      '34002302',
      '24424331',
      '10003130',
      NULL,
      '13422404',
      '03301041',
      '31313221',
      '31332324',
      '40403020',
      '10000024',
      '30341143',
      '21330041',
      '20203312',
      NULL,
      '03423233',
      '31400032',
      NULL,
      '42301434',
      '34213241',
      '00001320',
      '31221444',
      '14001341',
      '01121312',
      '33112330',
      '30211101',
      '12210243',
      '22424033',
      NULL,
      '12320412',
      '22322231',
      '11031330',
      '02322133',
      '44132201',
      '12412142',
      NULL,
      NULL,
      NULL,
      '12204121',
      '42100113',
      '10330212',
      '44000243',
      '04033114',
      '03203210',
      '03100433',
      '',
      '',
      NULL,
      NULL,
      '4422233',
      0.385540,
      6,
      2,
      NULL,
      '010213',
      0.819348,
      '10-13-1978',
      ' 5- 2-1981',
      9.626165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.790242,
      NULL,
      NULL,
      16.039249,
      116.790770,
      NULL,
      ' 9-27-1987',
      1,
      0,
      1,
      17.118635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.028156,
      14.520917,
      0.811398,
      1.482804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-14-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99,
      NULL,
      15,
      82,
      67,
      113.797902,
      84.429135,
      80,
      83.391049,
      31.846102,
      0.036538,
      NULL,
      ' 8-23-1992',
      15.824255,
      1,
      18.755683,
      30.140024,
      59,
      41,
      1.004838,
      '10-25-1977',
      5,
      1.147541,
      ' 5- 2-2002',
      NULL,
      NULL,
      8.325630,
      13,
      17,
      1.011906,
      NULL,
      4.264258,
      NULL,
      11.598298,
      NULL,
      1.841474,
      13.458810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-13-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      134.546760,
      ' 6-26-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.727531,
      112,
      8.506300,
      48.662377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856661,
      63,
      0.149541,
      0,
      NULL,
      1,
      0,
      74.770024,
      NULL,
      NULL,
      77,
      NULL,
      NULL,
      NULL,
      1,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.581021,
      NULL,
      NULL,
      NULL,
      60.942366,
      NULL,
      0.698503,
      13.954967,
      1,
      1,
      1,
      7.793598,
      0,
      27.189082,
      0.001945,
      16.351554,
      0,
      11,
      44,
      11,
      7,
      2.980017,
      20.951513,
      NULL,
      NULL,
      NULL,
      0,
      13.780492,
      7,
      3,
      4.043299,
      2,
      NULL,
      4.633594,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-16-1996',
      NULL,
      '10-13-1988',
      NULL);
commit;
end;
/


