set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8929907';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1140',
      '33411333',
      '00143320',
      NULL,
      '20411114',
      '10014311',
      '31124013',
      '20310213',
      '22424131',
      '11432223',
      '43202220',
      NULL,
      '02131240',
      '23311442',
      NULL,
      '23200220',
      '32001331',
      '22301343',
      '30332430',
      '33343144',
      '33313034',
      '43123020',
      NULL,
      '02024311',
      '34023314',
      '21142210',
      '04042320',
      '43114123',
      '31242002',
      NULL,
      '31014243',
      '10140423',
      '11421141',
      '33113023',
      NULL,
      '31434000',
      '12102403',
      '32413402',
      NULL,
      '23420001',
      '21132310',
      '20300000',
      '02233210',
      '32330311',
      '40203002',
      '442',
      '33',
      NULL,
      NULL,
      '4024120',
      0.689331,
      1,
      NULL,
      NULL,
      '104143',
      NULL,
      ' 9-17-1990',
      ' 1-13-1992',
      NULL,
      NULL,
      4,
      3,
      2,
      NULL,
      19.049265,
      10.789302,
      NULL,
      7.261308,
      NULL,
      6.066306,
      12.198682,
      0.707141,
      7.194682,
      26,
      17,
      4.709603,
      47.367677,
      13.968568,
      20,
      17,
      NULL,
      23,
      NULL,
      48.334163,
      NULL,
      NULL,
      37.322116,
      NULL,
      NULL,
      '10-28-1974',
      41.437002,
      4,
      27.825569,
      25.664444,
      81,
      NULL,
      ' 5-12-1992',
      1.820862,
      3.991199,
      4,
      0,
      1.401449,
      3,
      2.853597,
      NULL,
      1.889851,
      0.348072,
      1.408207,
      0.390454,
      0.818171,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 7-1995',
      16.173535,
      14,
      11.674921,
      3,
      8.851272,
      2.973917,
      ' 3- 2-1992',
      3,
      1.133232,
      34,
      1.982100,
      0.841534,
      145,
      NULL,
      3,
      58.919588,
      NULL,
      NULL,
      NULL,
      ' 2- 1-1976',
      4,
      NULL,
      34,
      1.907979,
      4.307174,
      58.239451,
      67,
      NULL,
      NULL,
      58,
      49.862885,
      45.850580,
      ' 5- 0-1994',
      25,
      24.974189,
      17,
      32,
      32.286602,
      141.514177,
      8.013434,
      ' 6- 0-1998',
      20,
      17.823700,
      ' 4-13-2000',
      9.239845,
      7.258049,
      NULL,
      NULL,
      2,
      NULL,
      1.851997,
      10.040512,
      0.102904,
      133,
      0.370192,
      1.122915,
      7.691557,
      NULL,
      1.667554,
      1.491479,
      NULL,
      1,
      NULL,
      4,
      NULL,
      3,
      NULL,
      43,
      4.987542,
      '11- 9-2001',
      53.107854,
      11.754396,
      ' 6-25-1989',
      17,
      NULL,
      42.562873,
      ' 5-16-1977',
      NULL,
      2,
      ' 7-25-1975',
      95.940781,
      19,
      ' 7-29-1986',
      0,
      10,
      '11-13-1975',
      10.870622,
      1.243625,
      ' 0-22-2000',
      3,
      2,
      NULL,
      '10-28-1974',
      58,
      0.308961,
      44,
      ' 3-29-1989',
      0.706820,
      49,
      ' 1-24-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


