set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9404807';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3002',
      '31414132',
      '41110131',
      '14214303',
      NULL,
      '40302400',
      '21311413',
      '43001240',
      '32130021',
      '40040234',
      '41012111',
      '00322302',
      '22320104',
      '30343020',
      '01320022',
      '40110122',
      '13344443',
      '43014142',
      '22223114',
      '13310301',
      '42440400',
      '20422321',
      '24441242',
      '10441330',
      '04330423',
      '13333212',
      '40444311',
      NULL,
      NULL,
      '23314243',
      '20304322',
      '43120314',
      '13322314',
      NULL,
      '00111334',
      NULL,
      '13434442',
      '13141434',
      '13130243',
      '32411432',
      '03404404',
      '02004101',
      '02133104',
      '40241012',
      '42110223',
      NULL,
      '01',
      NULL,
      NULL,
      '4001230',
      2.884090,
      NULL,
      NULL,
      NULL,
      '033231',
      2.018407,
      ' 6-15-1975',
      ' 7- 7-1992',
      NULL,
      NULL,
      3,
      4.144841,
      10,
      0.153137,
      49,
      14,
      4.520562,
      9.004943,
      6.798086,
      10,
      2.427372,
      11,
      8.153435,
      7,
      NULL,
      5,
      9.614431,
      10.911164,
      59,
      NULL,
      NULL,
      NULL,
      0,
      30.559354,
      50.706024,
      7.064001,
      111.306770,
      NULL,
      30.895874,
      ' 1-29-1977',
      0.276648,
      28.951545,
      14.475899,
      20.874466,
      NULL,
      75,
      NULL,
      NULL,
      1.352013,
      8,
      0.452094,
      NULL,
      1.419671,
      5.500323,
      0,
      1.712644,
      1,
      1.242367,
      0,
      1,
      1.633289,
      1.167067,
      1.497292,
      1.353042,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-28-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780016,
      0.096078,
      78,
      1,
      0,
      34,
      0.247833,
      1.537677,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      25.250052,
      78,
      51.755492,
      49.106848,
      1.871563,
      37.832488,
      27.975410,
      98,
      55.264512,
      NULL,
      NULL,
      13,
      ' 2- 0-1977',
      3.834024,
      3.472687,
      28.258197,
      38.279929,
      NULL,
      39.119711,
      4,
      '10-14-1980',
      11.438369,
      5.842603,
      NULL,
      1,
      NULL,
      11.934939,
      NULL,
      15.877764,
      5,
      2,
      NULL,
      0.511976,
      77.235563,
      0.958205,
      9,
      4.045663,
      5.693448,
      11,
      1,
      NULL,
      0,
      '11- 3-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 1-24-1988',
      NULL,
      NULL,
      NULL,
      25.356524,
      ' 8-14-1990',
      21.515548,
      NULL,
      NULL,
      12.560829,
      '11- 9-1996',
      105.486224,
      91,
      ' 0- 9-1989',
      9,
      NULL,
      ' 0- 2-1990',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      ' 5-12-1993',
      51.490204,
      NULL,
      1,
      NULL,
      0,
      NULL,
      '11- 5-1974',
      3,
      7.398529,
      19,
      NULL,
      NULL,
      NULL,
      1,
      72,
      '11-20-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


