set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1110',
      '02403321',
      NULL,
      NULL,
      '11424211',
      '33433043',
      '23331303',
      '21111204',
      '24203011',
      '32303301',
      '32321221',
      '22431220',
      '44020002',
      '30031300',
      NULL,
      '00331210',
      '01313233',
      '21324023',
      '11104344',
      NULL,
      '32332212',
      '03133441',
      '03241222',
      '03424341',
      '01344200',
      '10213034',
      '41134042',
      NULL,
      '31331303',
      '03120120',
      '20231033',
      '32310424',
      NULL,
      '32114301',
      NULL,
      '03334100',
      '24320103',
      '30011120',
      '44211132',
      '14021310',
      NULL,
      '00433433',
      '33302013',
      '12430202',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '3340034',
      3.263131,
      0.245055,
      NULL,
      NULL,
      '102023',
      0.664348,
      ' 5- 3-1980',
      ' 9-18-1979',
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      12,
      18.423541,
      NULL,
      NULL,
      NULL,
      NULL,
      4.758063,
      13.085004,
      5,
      28,
      18,
      7.352469,
      8,
      NULL,
      14,
      48,
      NULL,
      NULL,
      3,
      NULL,
      15.273849,
      NULL,
      21.184856,
      21.420604,
      NULL,
      30,
      NULL,
      13.802322,
      12.533308,
      20,
      6.689230,
      84,
      70.549041,
      ' 7-19-1976',
      NULL,
      1.627178,
      7.021765,
      0.215663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.884031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-22-1981',
      9,
      70,
      10.820514,
      66.136042,
      NULL,
      NULL,
      9,
      49,
      36.491997,
      74,
      78,
      14,
      ' 0-12-1979',
      2,
      21,
      14,
      52,
      24,
      NULL,
      NULL,
      NULL,
      3.355134,
      5.582503,
      ' 0-19-2001',
      0,
      1,
      6,
      4,
      7.201876,
      6,
      NULL,
      NULL,
      NULL,
      24.481158,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.719281,
      NULL,
      10.763134,
      ' 5-25-1975',
      0.049659,
      125,
      NULL,
      NULL,
      NULL,
      21.178914,
      8.179618,
      ' 1-29-1997',
      21,
      0.181908,
      40,
      ' 8-25-1989',
      NULL,
      NULL,
      NULL,
      13.955555,
      0,
      1.532389,
      60,
      88.830901,
      47.957043,
      NULL,
      27,
      30.032082,
      60,
      7.024077,
      104.356809,
      NULL,
      5.955516,
      65,
      9,
      3,
      2.336318,
      7.613001,
      1,
      94.579766,
      7,
      3,
      NULL,
      57,
      23,
      92,
      0.211726,
      89,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      103,
      31.149864,
      72,
      0.520176,
      67.016997,
      48,
      1.165540,
      1.166875,
      35,
      0,
      12,
      0,
      11.807495,
      1,
      82.580491,
      1,
      7.494392,
      1.716582,
      3,
      NULL,
      25,
      3,
      3.692303,
      82.595846,
      30.472335,
      5.364412,
      31.677554,
      16.289985,
      2,
      1.517934,
      0,
      3,
      1.061157,
      0.802705,
      2.583367,
      108,
      ' 4-15-1997',
      ' 7- 0-2000',
      NULL,
      ' 1-20-1988',
      ' 4-26-1994',
      ' 9-21-1999',
      ' 6-28-1986',
      NULL);
commit;
end;
/


