set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0401',
      '10124102',
      NULL,
      '42232041',
      '33313304',
      '43000122',
      '43212211',
      '11440420',
      NULL,
      '11332140',
      '01343210',
      NULL,
      NULL,
      '22220231',
      '03424121',
      '10414302',
      '22022031',
      '30432130',
      '11043300',
      '21143234',
      NULL,
      '23203401',
      '23344320',
      '44304213',
      '32124441',
      '24043222',
      '44231113',
      '03023441',
      '11303421',
      '01424000',
      NULL,
      NULL,
      '02213014',
      NULL,
      '24124233',
      '10131001',
      '33441142',
      '30222301',
      '11142300',
      '04204014',
      '00001000',
      '24133134',
      '14330322',
      '21323434',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '2414331',
      0.041039,
      14.316268,
      1,
      NULL,
      '434341',
      1.786754,
      ' 0-11-1978',
      ' 1- 9-1979',
      29.014061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.974443,
      4.795698,
      21.295827,
      NULL,
      155.753462,
      30,
      ' 8-29-1977',
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.058491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-29-1977',
      112,
      36.306214,
      2.321640,
      74,
      7.229191,
      70,
      60,
      93,
      7,
      NULL,
      NULL,
      13,
      NULL,
      15.157633,
      24.871327,
      4,
      37,
      1.750767,
      NULL,
      6.156660,
      ' 3-27-1997',
      10,
      15.333120,
      ' 2- 9-1995',
      4.276487,
      NULL,
      4,
      NULL,
      13,
      13.446348,
      NULL,
      20,
      NULL,
      125,
      1.561806,
      1.904814,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 2-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139691,
      62,
      ' 2- 8-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634984,
      0.309932,
      65,
      0.472506,
      0,
      77.931662,
      2,
      NULL,
      NULL,
      NULL,
      0.928252,
      193,
      96,
      NULL,
      NULL,
      0.021441,
      50,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      89,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680996,
      0.708474,
      6.858990,
      0,
      NULL,
      1.606075,
      10,
      1,
      18.173322,
      7,
      100,
      0,
      2,
      59,
      8.287558,
      5.753288,
      NULL,
      91,
      NULL,
      NULL,
      NULL,
      14,
      0,
      0.178149,
      0.780082,
      2.806160,
      1.053386,
      0.723918,
      NULL,
      57,
      NULL,
      NULL,
      NULL,
      ' 7-27-2001',
      ' 0-11-2000',
      NULL,
      ' 0-19-1989',
      NULL);
commit;
end;
/


