set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1003',
      '44301434',
      NULL,
      NULL,
      '30231423',
      '04242334',
      '00144224',
      '02204233',
      '22434333',
      '00104300',
      '21241233',
      '30011210',
      NULL,
      NULL,
      NULL,
      NULL,
      '02300100',
      '10334020',
      '32411342',
      NULL,
      '40400222',
      '31401130',
      '23232241',
      NULL,
      '42212014',
      '32101423',
      '22243311',
      NULL,
      '02424040',
      '04221432',
      '00211233',
      '04104042',
      NULL,
      '01123340',
      '22003102',
      '04302200',
      '20111431',
      '13014110',
      '10030142',
      '32041102',
      '14133103',
      NULL,
      NULL,
      '20300134',
      NULL,
      NULL,
      '03',
      NULL,
      NULL,
      NULL,
      1,
      117.268806,
      0,
      NULL,
      '223221',
      NULL,
      ' 6- 8-1974',
      ' 7-25-1985',
      40,
      NULL,
      16,
      NULL,
      NULL,
      15,
      5.745975,
      3.797109,
      15.716758,
      7,
      NULL,
      NULL,
      14,
      6,
      15,
      3,
      7.746855,
      15,
      52,
      9.105461,
      56.116771,
      NULL,
      0,
      1,
      0.764379,
      12.068280,
      81,
      NULL,
      106.012458,
      55,
      155.884249,
      ' 8- 7-1977',
      28,
      NULL,
      23,
      4.852697,
      74,
      62,
      ' 4-23-1979',
      1.170796,
      0,
      1.821439,
      0,
      1,
      NULL,
      NULL,
      0.421630,
      0.347759,
      0.076630,
      NULL,
      0.701091,
      NULL,
      0.075162,
      0.108992,
      0,
      1.644733,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      NULL,
      6.696614,
      4,
      10.672493,
      NULL,
      ' 9-15-1998',
      0.756920,
      NULL,
      49.774052,
      0,
      0.400890,
      119,
      NULL,
      0.674264,
      28,
      NULL,
      NULL,
      NULL,
      ' 8- 5-1989',
      NULL,
      56,
      NULL,
      NULL,
      28.818130,
      NULL,
      87,
      84,
      29.560959,
      NULL,
      29,
      52.642740,
      ' 8-11-1994',
      NULL,
      13,
      14,
      29,
      33.904343,
      52.647026,
      2.881452,
      NULL,
      1,
      7.250429,
      '10-29-2001',
      NULL,
      NULL,
      12,
      NULL,
      26.350322,
      11.416252,
      NULL,
      NULL,
      0,
      38,
      3,
      3,
      1,
      10.917450,
      2,
      1.941387,
      0,
      0.530466,
      NULL,
      0.901527,
      1,
      2.007754,
      '10- 9-1975',
      129.967312,
      13.420988,
      ' 3-21-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1991',
      18,
      ' 5-22-1983',
      1.386153,
      0,
      ' 6-17-2000',
      97,
      25,
      ' 6-25-1976',
      0.747413,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.563931,
      '10-14-2001',
      11,
      2,
      30.698227,
      ' 8- 7-1991',
      NULL,
      NULL,
      NULL,
      14,
      25.928875,
      NULL,
      4,
      NULL,
      55,
      0.958431,
      100.968894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


