set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4040',
      '12124032',
      '34134400',
      NULL,
      '22012033',
      '12140433',
      '13010330',
      NULL,
      '14310231',
      '14320303',
      NULL,
      '10221423',
      '34234303',
      '34133304',
      NULL,
      '41342033',
      NULL,
      NULL,
      '44002111',
      '42010122',
      NULL,
      '24344010',
      '14400024',
      '14231440',
      '23333224',
      '31003421',
      NULL,
      '04442422',
      '04111104',
      '00324041',
      '21321331',
      NULL,
      NULL,
      '03224222',
      '30103122',
      '33111432',
      '31303033',
      '20001331',
      '23120344',
      '13244112',
      '44311412',
      '32302401',
      '42324410',
      '10013204',
      '04322204',
      '',
      '',
      NULL,
      NULL,
      '0423110',
      3.714895,
      NULL,
      1,
      NULL,
      NULL,
      3.804336,
      ' 9- 6-1983',
      ' 9-17-1994',
      5,
      NULL,
      4.509775,
      1,
      24.324147,
      4.647207,
      NULL,
      0,
      NULL,
      6.562203,
      9,
      2.508358,
      NULL,
      6,
      22.638713,
      20,
      14,
      20,
      51.971751,
      12,
      46,
      5,
      57,
      6,
      NULL,
      67.373670,
      NULL,
      20.722663,
      NULL,
      10.903789,
      36.026696,
      '11- 9-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.093301,
      5.960735,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.950730,
      0,
      4,
      1,
      1.320092,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 1-1998',
      NULL,
      37,
      NULL,
      27,
      NULL,
      76,
      29,
      28,
      NULL,
      35.133203,
      0.908926,
      74.824040,
      NULL,
      NULL,
      NULL,
      7,
      11.553277,
      45.236925,
      2,
      5,
      ' 8- 4-1987',
      20.850311,
      8,
      NULL,
      5,
      13.275472,
      0.048940,
      9.965352,
      6,
      NULL,
      NULL,
      4.203322,
      NULL,
      65,
      3,
      2.294592,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 4-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.899872,
      10,
      NULL,
      NULL,
      138.183434,
      ' 5-14-1975',
      9,
      13,
      13,
      NULL,
      ' 1-16-1976',
      30.820439,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584951,
      36.598475,
      6,
      99.384628,
      41,
      NULL,
      16,
      13.187343,
      4.347107,
      77.820533,
      1,
      NULL,
      127.973969,
      0,
      0,
      123.185411,
      NULL,
      4.452119,
      176,
      8,
      1.097811,
      29.373898,
      1,
      3.912288,
      6.437644,
      1.580160,
      20.821151,
      0.505738,
      NULL,
      0.005550,
      1.867143,
      0,
      3.898374,
      32,
      68.516006,
      31.300332,
      10,
      NULL,
      18.066973,
      1,
      2.670007,
      14,
      1,
      8.573654,
      0,
      10.020728,
      0,
      5.293830,
      0,
      15.475694,
      NULL,
      1,
      36.797575,
      25.829024,
      NULL,
      1,
      45,
      23,
      3,
      53.325146,
      15.279414,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.350852,
      NULL,
      ' 2-21-1993',
      ' 9- 1-1982',
      ' 2- 9-1997',
      NULL,
      ' 4-10-1974',
      ' 2-14-1975',
      ' 5-13-1974',
      NULL);
commit;
end;
/


