set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24303123',
      '00242434',
      '22333044',
      NULL,
      '23011201',
      '11032314',
      '02311431',
      '34141244',
      '30331323',
      '02324401',
      '44133420',
      '10043100',
      '43400313',
      '12311421',
      '41430220',
      '23222101',
      NULL,
      '24320231',
      '00423222',
      '12221211',
      '24441212',
      '22030311',
      '04030000',
      '44244320',
      '24202342',
      NULL,
      '01101331',
      '12112234',
      NULL,
      '22111300',
      '23323041',
      '10033121',
      '44413320',
      '43103100',
      '20204343',
      '43141000',
      '12333102',
      '40113103',
      '34021314',
      '12222331',
      '24212413',
      '21010422',
      '22331020',
      '13222331',
      NULL,
      NULL,
      NULL,
      NULL,
      '1212103',
      0,
      22.555130,
      3,
      NULL,
      '212013',
      NULL,
      ' 5- 3-1996',
      ' 0- 6-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.757557,
      86,
      13.737177,
      3,
      0.383216,
      24.322148,
      NULL,
      26,
      15,
      NULL,
      1,
      2.751913,
      8.834816,
      69,
      11.491106,
      31,
      17.241527,
      34,
      NULL,
      NULL,
      NULL,
      129.297768,
      64.342926,
      64,
      10,
      NULL,
      ' 6-22-1974',
      NULL,
      0.677448,
      7,
      30.220390,
      165,
      206,
      ' 4-12-1978',
      0,
      2,
      5,
      2,
      9,
      6.346044,
      3.501386,
      3.516684,
      0,
      NULL,
      NULL,
      0.632762,
      1.929324,
      0,
      2.796077,
      1.907785,
      NULL,
      2.824029,
      0.532187,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-23-2002',
      30.829912,
      25.622948,
      NULL,
      NULL,
      18,
      1,
      ' 2-13-1986',
      1.030375,
      0,
      17.570585,
      0,
      NULL,
      45,
      1,
      0,
      68,
      NULL,
      NULL,
      NULL,
      ' 5- 6-1986',
      80,
      6.895215,
      4.493127,
      12,
      20.235972,
      16.649231,
      56,
      19.596333,
      10,
      82.688335,
      61,
      NULL,
      ' 8-11-1994',
      10.669469,
      17,
      1,
      16.235663,
      36.351213,
      9,
      NULL,
      ' 2-24-1990',
      7.323638,
      2,
      '10-22-1998',
      7.602262,
      5.164146,
      12.245835,
      9.368306,
      14,
      15,
      NULL,
      15.416801,
      1.191840,
      NULL,
      0.965677,
      8,
      16,
      10,
      2,
      2,
      NULL,
      1.106558,
      ' 8-19-1996',
      5.375516,
      0.395801,
      3,
      ' 2-22-1975',
      42.252815,
      8.159298,
      ' 0-15-1977',
      NULL,
      NULL,
      NULL,
      34,
      ' 1- 3-1977',
      42,
      ' 7- 0-1985',
      10,
      5.029756,
      NULL,
      102.840375,
      15,
      ' 6-16-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      13.337425,
      ' 4- 4-1985',
      NULL,
      NULL,
      41,
      ' 4-12-1985',
      NULL,
      NULL,
      NULL,
      4.315672,
      2,
      20,
      65.394916,
      ' 3- 7-1976',
      37.878328,
      1,
      137.026351,
      ' 0-13-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


