set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2134',
      '01204130',
      NULL,
      '42230142',
      '11411241',
      '14231111',
      '41220122',
      '12023312',
      '23213344',
      '21302210',
      '40314114',
      NULL,
      '34424323',
      '24332340',
      NULL,
      '43400440',
      NULL,
      '14000424',
      '10321003',
      '43312420',
      '41404013',
      '03131303',
      '34224041',
      '34012202',
      '23000201',
      '44130130',
      '12420332',
      '00002333',
      '44101034',
      '30301003',
      '00113243',
      '04044420',
      '10141402',
      NULL,
      '12231112',
      '10434432',
      '34012134',
      '22100021',
      '43100233',
      '40014333',
      '02332003',
      '10130201',
      NULL,
      '22304041',
      '14220031',
      '414',
      '24',
      NULL,
      0,
      '1410402',
      3.652192,
      34.736394,
      3,
      NULL,
      '434422',
      5.015233,
      ' 4- 2-1976',
      ' 5- 2-1995',
      64,
      NULL,
      3,
      1.203573,
      16.683962,
      14.225662,
      57,
      7,
      4.328849,
      8.031366,
      5,
      21.529472,
      26.818224,
      23.733038,
      30,
      8.853717,
      23.645544,
      NULL,
      NULL,
      21,
      28,
      8.107223,
      NULL,
      8,
      0.524678,
      87.414170,
      0,
      NULL,
      132,
      NULL,
      33.053308,
      ' 5- 8-1996',
      16,
      6,
      8,
      NULL,
      34.319032,
      69,
      ' 7-20-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      13.058215,
      11.785293,
      13.217431,
      NULL,
      ' 9-13-1996',
      NULL,
      3.458202,
      129.980090,
      1,
      4.954516,
      NULL,
      0.179201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-26-1979',
      82,
      63,
      48.982280,
      60,
      26.591845,
      34,
      36.784525,
      61,
      56.329344,
      73,
      NULL,
      NULL,
      '11- 9-1985',
      11,
      11,
      0.984674,
      40,
      35,
      NULL,
      7,
      '10-21-1990',
      NULL,
      22.501377,
      NULL,
      8.521950,
      15.095053,
      NULL,
      NULL,
      6,
      8,
      1,
      NULL,
      0,
      59,
      1.322088,
      2,
      18,
      4.748992,
      1.684911,
      6.141811,
      1,
      2.073537,
      '10-24-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      111,
      4.151369,
      ' 2-22-1982',
      NULL,
      NULL,
      NULL,
      47.433254,
      ' 7- 3-1992',
      NULL,
      ' 3- 8-1977',
      11,
      1.551445,
      ' 4-16-2003',
      105.490412,
      105.830343,
      ' 6-29-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      20,
      NULL,
      29,
      37,
      29,
      ' 5-29-2002',
      0.867074,
      NULL,
      ' 9-25-1979',
      5,
      33,
      6.814883,
      NULL,
      ' 8- 0-1995',
      NULL,
      0.188386,
      54,
      ' 5- 7-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


