set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '4',
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      '4',
      NULL,
      '0',
      '1',
      '2',
      '1',
      '2',
      '1',
      '0',
      '1',
      '1',
      NULL,
      '0',
      NULL,
      '4',
      '',
      '2',
      '1',
      '4',
      '4',
      '2',
      '',
      '',
      '3',
      '3',
      '2',
      '4',
      '1',
      '0',
      NULL,
      '1',
      '1',
      '0',
      '2',
      '410',
      '00012212',
      37,
      18,
      NULL,
      NULL,
      147.505929,
      3,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      195.908907,
      29.163577,
      14.987155,
      NULL,
      9,
      62,
      12,
      4.982812,
      4,
      5.878158,
      3,
      NULL,
      8.539122,
      NULL,
      12,
      20,
      16,
      NULL,
      19.131988,
      21.850079,
      14,
      72,
      6,
      1.624338,
      10,
      31,
      46.431824,
      NULL,
      NULL,
      NULL,
      ' 8- 2-2002',
      44.014003,
      14.725304,
      29,
      30,
      172,
      42.055525,
      ' 9-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      27.302041,
      19,
      0,
      ' 5-13-1983',
      1,
      0.396670,
      14.343762,
      1.560998,
      NULL,
      87.505550,
      0.843004,
      0.835014,
      1.757806,
      NULL,
      NULL,
      NULL,
      '11-17-2000',
      NULL,
      6,
      51.550724,
      13,
      69.148240,
      NULL,
      23.064869,
      3,
      71,
      65.634730,
      NULL,
      47.119795,
      ' 3-20-1975',
      10.009856,
      20.560405,
      13,
      49.048355,
      30.676761,
      40.570977,
      1,
      '11-21-2000',
      6,
      NULL,
      ' 7-12-1992',
      3.846812,
      8,
      5,
      13,
      3,
      1.805916,
      2,
      13,
      0,
      71.134746,
      8.678534,
      1,
      17.448747,
      15.446909,
      1,
      1,
      1,
      1,
      '10- 8-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-17-1985',
      2.032601,
      NULL,
      NULL,
      8,
      ' 1-23-1975',
      9,
      83.982794,
      '10- 6-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.930330,
      NULL,
      71,
      NULL,
      NULL,
      ' 4- 0-1981',
      1.965838,
      84.991705,
      ' 0-24-1996',
      7.584706,
      NULL,
      NULL,
      56,
      '11-15-1996',
      12,
      1,
      48,
      ' 8- 5-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


