set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '2',
      '1',
      '3',
      '4',
      '1',
      NULL,
      '3',
      '4',
      NULL,
      '1',
      '4',
      '3',
      '4',
      '4',
      '0',
      '1',
      '0',
      '4',
      '3',
      '0',
      '4',
      '4',
      NULL,
      '0',
      '',
      '3',
      NULL,
      '3',
      '0',
      '2',
      '',
      '',
      '0',
      '2',
      NULL,
      '3',
      NULL,
      NULL,
      '0',
      NULL,
      '0',
      '1',
      '0',
      NULL,
      '00023422',
      NULL,
      44,
      '3000021',
      3,
      112.907141,
      3,
      1,
      '142000',
      4,
      ' 2-20-1985',
      ' 7-13-1978',
      100,
      NULL,
      2,
      4.793798,
      7.996201,
      0,
      0,
      12,
      6,
      12.978166,
      31.049278,
      9,
      NULL,
      4.356332,
      5,
      24.658203,
      9.731029,
      14.744315,
      NULL,
      17,
      16.632970,
      8,
      21,
      10,
      1.966456,
      87,
      98.387001,
      NULL,
      202.815174,
      112,
      81,
      ' 8- 9-1977',
      NULL,
      39.182361,
      22,
      12.169898,
      NULL,
      NULL,
      ' 4-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643477,
      16,
      23,
      35,
      NULL,
      1,
      ' 9-17-1997',
      0,
      0,
      37,
      NULL,
      0,
      88,
      0,
      1,
      28,
      NULL,
      NULL,
      NULL,
      ' 8-28-1989',
      81,
      87,
      57,
      77.417938,
      NULL,
      5,
      35,
      17.562167,
      55,
      57.752696,
      NULL,
      0.468535,
      ' 7-19-1974',
      9,
      NULL,
      13,
      45,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      2.447842,
      ' 0- 5-1976',
      3.693899,
      11.546118,
      13,
      14.807108,
      20.208370,
      2,
      0.880322,
      12,
      NULL,
      53.407712,
      NULL,
      0,
      13.873092,
      5.669855,
      2,
      7,
      NULL,
      0.974023,
      ' 8-10-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      115.007571,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-21-1979',
      38.399421,
      NULL,
      NULL,
      1.321460,
      NULL,
      45,
      46.400082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      13.367564,
      ' 9-20-2000',
      30,
      26.133113,
      21,
      NULL,
      2.382286,
      257,
      ' 3- 9-1985',
      3,
      NULL,
      NULL,
      56,
      ' 7-26-1980',
      49,
      1,
      19,
      ' 0- 8-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


