set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7920724';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2330',
      '04323204',
      '22104420',
      '21322423',
      NULL,
      '14443032',
      '23421423',
      '44431101',
      '03013013',
      NULL,
      '21141304',
      NULL,
      '40210004',
      '23121014',
      '40142132',
      '12401331',
      '41023401',
      '43000420',
      '04012404',
      '01101142',
      '11211043',
      '20341214',
      NULL,
      '11304243',
      NULL,
      '10001412',
      '21033202',
      '32131401',
      '31132101',
      '20423101',
      '21240340',
      '11034340',
      NULL,
      '40310421',
      '01110033',
      '20312343',
      '41301142',
      '11132024',
      '41130044',
      '23224230',
      '14230042',
      '23111043',
      NULL,
      NULL,
      '30010334',
      NULL,
      '02',
      NULL,
      NULL,
      '4102420',
      NULL,
      1,
      0,
      NULL,
      '314032',
      0.917408,
      ' 0-17-1986',
      NULL,
      10.701813,
      NULL,
      NULL,
      NULL,
      13,
      9.456511,
      103,
      16,
      3.117201,
      14,
      47.541228,
      NULL,
      40.991253,
      12,
      5.162616,
      4,
      12.948012,
      13,
      51,
      5.852185,
      NULL,
      NULL,
      7,
      11,
      0,
      59.871577,
      NULL,
      NULL,
      219.058118,
      NULL,
      NULL,
      NULL,
      47,
      53,
      1.118579,
      NULL,
      98,
      NULL,
      '10- 3-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7.544227,
      4,
      5.157657,
      8.365915,
      ' 4- 1-2000',
      1.512722,
      1,
      77,
      2.316582,
      5.391850,
      89.993792,
      0,
      2.776692,
      90.414267,
      NULL,
      NULL,
      NULL,
      ' 4-29-1974',
      74.993046,
      74,
      19.504019,
      12,
      122.510392,
      49.314178,
      32.716795,
      59.013147,
      94,
      45,
      NULL,
      62,
      ' 1- 4-1985',
      NULL,
      0,
      13.299189,
      103.877974,
      26.850151,
      117,
      NULL,
      ' 4-11-1987',
      18,
      20,
      NULL,
      NULL,
      14,
      17.402595,
      17.367137,
      NULL,
      6.103850,
      1.852843,
      4.973612,
      0.759076,
      123.530291,
      2.738601,
      4,
      16.848107,
      4,
      4.832780,
      0,
      0.031191,
      NULL,
      ' 4-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      137,
      13.945045,
      ' 1- 4-1993',
      NULL,
      NULL,
      NULL,
      43.005485,
      '10-15-1990',
      NULL,
      ' 1-16-1996',
      9.047409,
      12.441461,
      ' 7-21-2001',
      115.573745,
      129,
      ' 8-23-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      17,
      ' 0-24-1988',
      NULL,
      41,
      10,
      ' 6-22-1999',
      1.231019,
      2.483149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


