set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693311';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      '1',
      '0',
      '1',
      '4',
      '0',
      NULL,
      NULL,
      '1',
      '0',
      '0',
      '3',
      NULL,
      '3',
      '1',
      '0',
      '4',
      '1',
      '1',
      NULL,
      '3',
      '2',
      '',
      NULL,
      '',
      '1',
      '2',
      '3',
      NULL,
      '1',
      '',
      '',
      '3',
      '2',
      '1',
      NULL,
      '4',
      '3',
      '4',
      '4',
      '2',
      '1',
      '0',
      '231',
      NULL,
      54,
      41,
      '4234002',
      1.346324,
      1.632626,
      NULL,
      NULL,
      NULL,
      3.831234,
      ' 3-23-1993',
      ' 0-10-2002',
      47,
      15,
      25,
      21,
      NULL,
      8,
      88.573383,
      8.161865,
      17.993815,
      10.994975,
      12,
      15.703499,
      0.796743,
      10,
      9,
      5.117303,
      9,
      9.091494,
      39.661413,
      17,
      40.520934,
      19,
      19.920096,
      22,
      0,
      13,
      105,
      74,
      35,
      0,
      123.664589,
      '10- 0-1990',
      23,
      58.255700,
      9,
      22.755612,
      83.412720,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      5.800898,
      11.332167,
      9.976182,
      8.700407,
      9.746692,
      ' 8-23-1995',
      0,
      1,
      NULL,
      NULL,
      NULL,
      41.528664,
      0.506153,
      0,
      84,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      NULL,
      56.724607,
      59.120562,
      74,
      NULL,
      35,
      64.691190,
      3.872817,
      18,
      5.911177,
      ' 4- 6-1974',
      9,
      12.122873,
      5.431435,
      43.898869,
      39,
      35,
      8.794879,
      NULL,
      36,
      30.644305,
      NULL,
      12.060367,
      14.734805,
      5,
      0,
      6,
      8.622428,
      NULL,
      21,
      0,
      52,
      0,
      5.795110,
      12.689530,
      23.305450,
      1,
      1.771667,
      0.266111,
      1,
      ' 0- 4-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      1.371735,
      ' 7-14-1978',
      NULL,
      NULL,
      NULL,
      48,
      ' 5-15-1986',
      7.256149,
      NULL,
      NULL,
      NULL,
      ' 8-23-1978',
      47.407896,
      28,
      ' 6-24-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      17,
      ' 5-29-1976',
      23.327085,
      20.658252,
      NULL,
      '10- 2-2000',
      1,
      NULL,
      '11-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


