set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9813353';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '4',
      NULL,
      '2',
      '0',
      NULL,
      '4',
      NULL,
      '4',
      NULL,
      '2',
      '4',
      '1',
      NULL,
      '0',
      '3',
      '2',
      '4',
      '4',
      '4',
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      '3',
      '1',
      NULL,
      '',
      '',
      '1',
      '4',
      '2',
      '0',
      '3',
      '4',
      '0',
      '0',
      '2',
      '2',
      '2',
      '211',
      NULL,
      NULL,
      31.221857,
      '2442333',
      2,
      NULL,
      NULL,
      NULL,
      '020404',
      2,
      ' 4-19-1989',
      ' 7-20-1998',
      109,
      189,
      15,
      NULL,
      9.331011,
      19,
      NULL,
      2.729223,
      NULL,
      10,
      33,
      17,
      33,
      9,
      23.718667,
      13.579773,
      4.482458,
      12,
      62.285501,
      NULL,
      26.350775,
      7,
      51.021525,
      2.003762,
      0,
      NULL,
      120.751982,
      6.591190,
      NULL,
      3.811585,
      55,
      ' 0-28-1984',
      37.075125,
      53.790899,
      16,
      NULL,
      157.412185,
      139.747599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      22,
      1.299612,
      4,
      NULL,
      0,
      ' 6-20-2000',
      NULL,
      1,
      NULL,
      NULL,
      1,
      132.640485,
      1,
      0,
      63,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1979',
      62.808991,
      97.329403,
      73,
      NULL,
      NULL,
      50.794187,
      100.510588,
      16.535576,
      NULL,
      32.652325,
      44,
      32.176558,
      ' 8-25-2001',
      5.540803,
      11,
      6,
      NULL,
      NULL,
      145,
      7,
      '11- 1-1987',
      20,
      12.904059,
      ' 9-28-1991',
      1.496889,
      3.563085,
      10.142141,
      8.096852,
      NULL,
      1.877690,
      NULL,
      6.309329,
      NULL,
      24,
      3.237986,
      NULL,
      0.413055,
      NULL,
      1.810638,
      9.779992,
      1.236477,
      0,
      '11- 0-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-17-1988',
      NULL,
      NULL,
      NULL,
      14.052106,
      NULL,
      12,
      ' 4- 4-1990',
      0,
      2.513358,
      ' 4-23-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '10- 0-1996',
      46.584070,
      NULL,
      5,
      ' 9- 8-1983',
      2,
      59,
      ' 6-10-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


