set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8533544';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1213',
      '44400133',
      '01004143',
      '14243104',
      '10333334',
      '33440140',
      '40430302',
      '41043412',
      '13430012',
      '04104402',
      '13224143',
      '10022312',
      '32222220',
      '11242440',
      '33304141',
      '04240024',
      '12140420',
      NULL,
      '32033220',
      '20412320',
      '30404010',
      '30420400',
      '13012122',
      '41011232',
      NULL,
      NULL,
      '43214412',
      '13011331',
      '01004311',
      '02413113',
      '24330203',
      '23423421',
      NULL,
      '41102424',
      '30001004',
      '14330343',
      '20130241',
      '11104301',
      '10334130',
      '33424034',
      '21114442',
      '21021422',
      '41110430',
      '31410420',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '0033314',
      2.034271,
      1.741799,
      2,
      NULL,
      '421413',
      1,
      ' 9- 4-1988',
      ' 0-18-1994',
      45,
      NULL,
      NULL,
      1.577418,
      16.232612,
      3.357072,
      83,
      1,
      NULL,
      9,
      14,
      1.984470,
      42.032171,
      NULL,
      8.947610,
      16,
      18.611791,
      20,
      54,
      3,
      27,
      4,
      92,
      3.209735,
      NULL,
      NULL,
      150,
      77,
      4,
      49,
      149,
      ' 0-22-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.561049,
      0.957562,
      0.622658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995553,
      NULL,
      1.277056,
      0,
      0.321937,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-26-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-25-1998',
      9,
      NULL,
      87,
      NULL,
      NULL,
      89.923796,
      111,
      NULL,
      70.512465,
      63.200880,
      95.593030,
      14,
      '10- 7-1980',
      21,
      4.680999,
      NULL,
      NULL,
      39,
      38.981279,
      6.555528,
      '10-10-1981',
      7,
      1.334610,
      ' 6- 4-1976',
      NULL,
      NULL,
      NULL,
      7,
      15,
      2.456290,
      NULL,
      9,
      NULL,
      NULL,
      0.613360,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-10-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.284543,
      41,
      NULL,
      '11-20-1988',
      1.564250,
      NULL,
      '11-12-1979',
      NULL,
      NULL,
      20.174579,
      NULL,
      ' 3- 1-1987',
      59,
      1.651284,
      41,
      '11-20-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      1.307505,
      0,
      94.398811,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.058574,
      NULL,
      79.720465,
      NULL,
      NULL,
      NULL,
      1.058036,
      0.354539,
      96.357431,
      1.204064,
      NULL,
      188,
      121,
      10,
      NULL,
      0.429786,
      53.502589,
      0.456738,
      0,
      NULL,
      1.745818,
      NULL,
      0.076368,
      105.353146,
      56.671701,
      57,
      22.312912,
      11,
      52.166055,
      0.316701,
      0,
      42,
      NULL,
      NULL,
      0,
      5,
      0.412457,
      26,
      0,
      36,
      1.149453,
      NULL,
      89,
      30,
      9.985685,
      3.940835,
      NULL,
      98,
      11,
      63,
      1.669891,
      7.151230,
      0,
      1.805363,
      0,
      1,
      1,
      0.919043,
      NULL,
      NULL,
      '10-20-2003',
      ' 3-13-1975',
      '10-15-1997',
      '10-12-1988',
      ' 5- 9-1974',
      '11-25-1989',
      NULL);
commit;
end;
/


