set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '1',
      '0',
      '3',
      '4',
      '1',
      '3',
      '3',
      '2',
      '3',
      '4',
      '0',
      '1',
      '1',
      '2',
      '3',
      '2',
      '1',
      NULL,
      '3',
      '4',
      '2',
      '2',
      '',
      '1',
      '',
      '1',
      '1',
      '1',
      NULL,
      '2',
      '',
      NULL,
      '2',
      '1',
      '0',
      '3',
      '1',
      NULL,
      '3',
      NULL,
      '1',
      '3',
      '0',
      '012',
      '10341022',
      64,
      4,
      '3142203',
      3,
      0,
      3,
      NULL,
      NULL,
      5,
      NULL,
      ' 3-25-1997',
      25,
      131.101829,
      NULL,
      9.414317,
      15,
      NULL,
      NULL,
      18,
      28,
      10,
      NULL,
      17,
      19,
      6,
      27.388267,
      25.139876,
      12,
      3.495882,
      NULL,
      19.234476,
      NULL,
      12.301853,
      42.233976,
      6.462998,
      0,
      34.292411,
      186,
      60.932526,
      NULL,
      25.050195,
      NULL,
      ' 8- 5-1979',
      41.285850,
      70,
      21.919574,
      21,
      NULL,
      185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86.167750,
      7.555662,
      0,
      NULL,
      3,
      3.006508,
      '10-23-2001',
      1.562005,
      1,
      NULL,
      1,
      4,
      145,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-17-2000',
      69.886346,
      71.319566,
      63.086292,
      96.744430,
      64,
      NULL,
      59,
      78.910050,
      NULL,
      50,
      44,
      9.853355,
      ' 1- 8-1988',
      NULL,
      18,
      NULL,
      39.616068,
      58.804804,
      5.262661,
      8,
      ' 2- 4-1995',
      6,
      1.867283,
      ' 7-19-1999',
      5,
      15.084795,
      NULL,
      0.707241,
      20.320643,
      NULL,
      1,
      25,
      1,
      NULL,
      NULL,
      NULL,
      1.928154,
      10.894098,
      0.855910,
      1.011186,
      0.496423,
      0,
      ' 3-25-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      ' 9-23-1986',
      NULL,
      ' 3-11-1996',
      9.567689,
      6,
      '11-12-1993',
      134.574407,
      72.870365,
      ' 5-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-17-1978',
      46,
      55,
      46,
      ' 8-18-1993',
      1,
      54,
      ' 4-12-1976',
      2.911914,
      4,
      23.846588,
      NULL,
      ' 4-15-2000',
      50,
      NULL,
      167,
      '10-24-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


