set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      '1',
      '2',
      NULL,
      '2',
      NULL,
      '0',
      '1',
      '0',
      '4',
      NULL,
      NULL,
      '0',
      '3',
      '3',
      '4',
      '1',
      '0',
      '1',
      '',
      NULL,
      '',
      NULL,
      '4',
      '4',
      '4',
      '2',
      '',
      '',
      '3',
      '4',
      '3',
      NULL,
      NULL,
      '0',
      '4',
      '4',
      '4',
      '4',
      '2',
      '022',
      '42113410',
      10.813876,
      17,
      '2424014',
      3,
      17,
      3,
      0,
      '320203',
      0,
      ' 7-14-1995',
      NULL,
      227,
      60.171628,
      13.348633,
      1,
      NULL,
      2.081035,
      35.594681,
      13,
      NULL,
      6.499488,
      27.028994,
      13.608095,
      0.239379,
      18,
      15,
      22,
      21.547090,
      5.227618,
      NULL,
      NULL,
      32,
      12.753630,
      120,
      14.630491,
      1.074481,
      NULL,
      NULL,
      112,
      47.323255,
      NULL,
      211.910590,
      NULL,
      4,
      8,
      NULL,
      21,
      108,
      NULL,
      ' 2- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      115.286739,
      14,
      5.579838,
      NULL,
      0,
      1,
      ' 9- 3-1996',
      0.974738,
      NULL,
      119.030074,
      0.554985,
      1.518855,
      4,
      0,
      1,
      12,
      NULL,
      NULL,
      NULL,
      ' 0-28-1988',
      101,
      91,
      114.313312,
      46,
      91,
      NULL,
      92.983797,
      20,
      NULL,
      86.694874,
      18,
      70,
      NULL,
      18.132267,
      7.436936,
      10.737284,
      59.101277,
      NULL,
      67,
      1.513278,
      NULL,
      5.374047,
      NULL,
      ' 5-17-1982',
      NULL,
      8,
      3,
      3,
      NULL,
      9,
      0.029656,
      19,
      1,
      42,
      1,
      NULL,
      26,
      5.683007,
      1.541358,
      1,
      NULL,
      0.835397,
      '11- 7-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      185,
      27.984518,
      NULL,
      NULL,
      NULL,
      NULL,
      36.791597,
      ' 0-21-1989',
      4,
      ' 8- 6-1998',
      16,
      NULL,
      ' 8-25-1986',
      102.201575,
      116.704888,
      ' 1-15-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 5-25-1984',
      8.435273,
      24.301651,
      8,
      '11-21-2000',
      1,
      49,
      ' 3-26-1986',
      3.355771,
      40.081481,
      17.470655,
      NULL,
      ' 7-10-1999',
      25,
      0.259341,
      197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


