set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9852721';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '2',
      '2',
      NULL,
      '2',
      '2',
      '0',
      '1',
      '2',
      '1',
      '0',
      '3',
      NULL,
      '3',
      '3',
      '2',
      '2',
      '3',
      '3',
      '3',
      '2',
      '0',
      '3',
      '',
      '4',
      NULL,
      '0',
      NULL,
      '0',
      NULL,
      '2',
      NULL,
      '',
      '2',
      '3',
      '1',
      '3',
      '1',
      '0',
      NULL,
      '2',
      NULL,
      '0',
      '3',
      '413',
      NULL,
      61.132877,
      35,
      '2422121',
      3,
      1.029792,
      NULL,
      NULL,
      '013133',
      2.908937,
      ' 0- 2-1998',
      ' 6-12-1995',
      33,
      6.449873,
      3.964241,
      17.182915,
      NULL,
      8,
      60,
      NULL,
      NULL,
      9.986218,
      0.864459,
      NULL,
      18.812962,
      7.406016,
      30,
      15,
      NULL,
      11,
      94,
      16.063664,
      52,
      24,
      90.108484,
      16.152463,
      NULL,
      60,
      30,
      40.888309,
      64.003593,
      18,
      108,
      ' 0-22-2000',
      NULL,
      9,
      NULL,
      16.062111,
      67,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      20.237789,
      9.643629,
      7,
      7.836600,
      10.644929,
      ' 5- 2-1975',
      NULL,
      1.018186,
      35.852520,
      0,
      0,
      163.345829,
      0,
      1,
      94,
      NULL,
      NULL,
      NULL,
      ' 9-14-2000',
      11.827390,
      72,
      NULL,
      69,
      51.719799,
      NULL,
      NULL,
      22,
      NULL,
      38.189170,
      11.610925,
      NULL,
      NULL,
      0,
      7,
      28.733230,
      78,
      NULL,
      55.064532,
      5.311136,
      ' 5-11-1994',
      6,
      NULL,
      ' 2-21-1999',
      8.172622,
      NULL,
      16,
      20,
      7,
      NULL,
      0.675475,
      17,
      0,
      29.254376,
      NULL,
      1,
      NULL,
      4.401175,
      0,
      NULL,
      1.514116,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.356856,
      '10-11-2001',
      NULL,
      NULL,
      NULL,
      7.473693,
      '11-24-1996',
      6,
      ' 7-17-1978',
      1.441020,
      15,
      ' 4- 1-1989',
      7,
      3,
      ' 1-22-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6,
      ' 4-14-1997',
      26.895104,
      24.398326,
      12,
      NULL,
      0,
      122.488667,
      '10- 1-1975',
      12,
      18,
      5,
      36,
      ' 6-21-1984',
      52.863830,
      0.796808,
      52.725045,
      '11-18-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


