set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8828445';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02131223',
      '21441030',
      '30410010',
      '04033000',
      '13211224',
      '34343142',
      '23420131',
      '30144014',
      '11334233',
      '32341413',
      '24301331',
      '33310330',
      '32124113',
      NULL,
      '41032303',
      '30314141',
      '32100103',
      '43123233',
      '00414030',
      '12230310',
      '33400224',
      '43202040',
      NULL,
      '32013443',
      '40301224',
      '32040302',
      '22411023',
      '43021213',
      '11240240',
      NULL,
      '40434002',
      '00100243',
      '40120114',
      '03431043',
      NULL,
      '01130212',
      '40044430',
      NULL,
      '22311204',
      '04211400',
      '11233331',
      '12303114',
      '13330011',
      '30041430',
      '',
      '',
      NULL,
      NULL,
      '0443143',
      3,
      1,
      1,
      NULL,
      '022112',
      0.978461,
      ' 2- 2-1989',
      ' 8-28-1992',
      NULL,
      NULL,
      39.236739,
      22,
      31.541221,
      10,
      NULL,
      17.920270,
      12,
      11,
      31,
      11,
      NULL,
      9,
      32.098914,
      12.405767,
      NULL,
      18,
      20.915289,
      20,
      57.026444,
      NULL,
      1,
      21.382590,
      NULL,
      51.996708,
      143.191907,
      95.820572,
      NULL,
      176.165989,
      105.632994,
      '11-20-1991',
      33,
      38,
      NULL,
      2.260848,
      166,
      36.376674,
      '10-13-1982',
      2,
      NULL,
      1.709470,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.630024,
      1.648113,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-17-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-12-2002',
      29.725792,
      107.894442,
      58.066674,
      62,
      75,
      NULL,
      120,
      92.306897,
      18,
      35,
      58.326824,
      73,
      ' 1- 2-1975',
      30.616722,
      22.400491,
      19,
      71,
      2,
      57.163195,
      9,
      ' 1- 0-2003',
      20.167980,
      12.691756,
      ' 3- 7-1979',
      4.173094,
      7.948217,
      14.664731,
      11,
      31.895154,
      16,
      NULL,
      30,
      NULL,
      164,
      1,
      NULL,
      12.193948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-10-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      5,
      42,
      ' 1-15-1980',
      1.401527,
      74.620626,
      NULL,
      11,
      21.509557,
      NULL,
      27.319385,
      ' 4- 3-1989',
      19,
      0,
      114.957775,
      '11-20-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      1.014396,
      0.111927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482157,
      0,
      64,
      NULL,
      1.999252,
      NULL,
      0.564303,
      0,
      55,
      3,
      2,
      197,
      NULL,
      14,
      NULL,
      0.652615,
      NULL,
      0.933239,
      0.219450,
      1,
      0.983594,
      0,
      1,
      NULL,
      NULL,
      NULL,
      7.807993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.108177,
      0,
      NULL,
      23.847775,
      11.157830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      1.157184,
      NULL,
      1.153325,
      0,
      1,
      0.192809,
      NULL,
      NULL,
      NULL,
      ' 9-26-1982',
      ' 6- 1-1974',
      NULL,
      ' 9-15-1978',
      ' 2-19-1980',
      ' 6-28-2002',
      NULL);
commit;
end;
/


