set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331679';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4300',
      NULL,
      '00313443',
      '13133110',
      '34400334',
      '21313010',
      '31204131',
      NULL,
      NULL,
      '20014333',
      '10442043',
      '30443012',
      '20100403',
      '04210034',
      NULL,
      '23121342',
      '22014012',
      '22234101',
      '34420440',
      '40003332',
      '00021204',
      '31123233',
      NULL,
      NULL,
      '10014222',
      '13221014',
      '01412211',
      '00440120',
      '43023341',
      '44324340',
      '01222431',
      '23100442',
      '04423301',
      '01023411',
      '22231432',
      NULL,
      '43112313',
      '11301024',
      '13434044',
      NULL,
      '00410041',
      NULL,
      '21330233',
      '24424141',
      '43111041',
      NULL,
      '32',
      NULL,
      NULL,
      '4020413',
      0,
      0,
      0,
      NULL,
      '432202',
      0.018851,
      ' 4- 8-1975',
      NULL,
      41.586419,
      NULL,
      19,
      0,
      27,
      7,
      87,
      17.029460,
      6,
      0,
      34,
      16,
      NULL,
      4,
      14,
      11,
      17.740678,
      NULL,
      23.228141,
      NULL,
      39.381207,
      10.705607,
      NULL,
      16,
      1.482276,
      15,
      24,
      13.406224,
      70.542170,
      157,
      153.953074,
      ' 8-18-1981',
      5,
      8,
      29.679202,
      3,
      145,
      132,
      NULL,
      0.758716,
      1.500056,
      1.485425,
      0,
      3,
      NULL,
      0.203893,
      0.644812,
      0,
      0.901506,
      1.847868,
      1.639743,
      1.248195,
      NULL,
      1,
      0,
      0.159060,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.228867,
      NULL,
      NULL,
      6,
      19,
      NULL,
      ' 9-29-1989',
      0.025593,
      0.285700,
      18.335605,
      1,
      1.572285,
      105.912849,
      3.133871,
      0,
      36.953629,
      NULL,
      NULL,
      NULL,
      '11-11-1981',
      40.167120,
      12.279003,
      NULL,
      90.604379,
      49.094947,
      26.998677,
      67.603782,
      15,
      NULL,
      57,
      38.695086,
      36,
      ' 8-28-1999',
      16.072940,
      3,
      6.609467,
      24,
      28,
      32.136237,
      0.709240,
      ' 3-21-1975',
      9,
      NULL,
      NULL,
      8.807485,
      5.281454,
      7.961238,
      17,
      4.601288,
      4.974941,
      0.828141,
      8,
      0,
      45,
      NULL,
      2,
      16.879245,
      26,
      1,
      NULL,
      3.491511,
      NULL,
      ' 2-23-1984',
      NULL,
      4.721499,
      NULL,
      '11-22-2002',
      5,
      17,
      NULL,
      20.582041,
      22,
      ' 1- 7-1994',
      NULL,
      NULL,
      39.309272,
      '10-25-1991',
      NULL,
      NULL,
      ' 9-17-1993',
      43.665768,
      120,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      ' 2- 3-1982',
      66,
      13,
      NULL,
      ' 9- 5-1991',
      NULL,
      52.390848,
      ' 7-17-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10);
commit;
end;
/


