set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331679';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3401',
      '24230421',
      '40423334',
      '21413321',
      '41101330',
      NULL,
      '33412403',
      '30121010',
      NULL,
      NULL,
      '23122321',
      '33302032',
      '32102104',
      NULL,
      '20132014',
      '10220242',
      '12302212',
      '40211100',
      '04114333',
      NULL,
      '41112041',
      '04112013',
      '10200011',
      '42110141',
      '10113402',
      '21203103',
      '01230014',
      '10043040',
      '42234223',
      NULL,
      '34041104',
      NULL,
      '12014322',
      '04300430',
      '33034433',
      '32404230',
      '32141013',
      '03313224',
      '32434412',
      '33422101',
      NULL,
      '34112444',
      '43302031',
      '43304112',
      '12233341',
      '223',
      '24',
      NULL,
      NULL,
      NULL,
      1,
      1.922770,
      NULL,
      NULL,
      '140143',
      0.723501,
      ' 1-20-1976',
      '10-19-1997',
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      55.355334,
      10.089947,
      NULL,
      NULL,
      NULL,
      3.654952,
      4.114281,
      NULL,
      35,
      4.590950,
      12,
      13,
      9,
      7.595125,
      NULL,
      2,
      85.938150,
      14,
      1.010558,
      39.772880,
      NULL,
      3.017822,
      91.401695,
      109.775237,
      90.789070,
      NULL,
      NULL,
      NULL,
      27.277624,
      15.320082,
      55.250421,
      87,
      '11-21-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.393516,
      NULL,
      14.974405,
      NULL,
      8.173246,
      NULL,
      '10-20-2002',
      0,
      1,
      60.257528,
      1,
      3.096277,
      144,
      1,
      0,
      121,
      NULL,
      NULL,
      NULL,
      NULL,
      100,
      92,
      62.684314,
      31,
      14,
      96,
      47.902006,
      92,
      70,
      NULL,
      53.551188,
      NULL,
      ' 2-14-1995',
      17,
      19,
      23,
      NULL,
      35.264028,
      124.834065,
      NULL,
      NULL,
      14.482051,
      NULL,
      ' 0-26-1974',
      5,
      NULL,
      8,
      9.684143,
      2.405499,
      0.846867,
      0,
      17.593583,
      1,
      106.145304,
      1,
      NULL,
      5.068009,
      NULL,
      1.324706,
      0.213078,
      0.685664,
      1.970948,
      ' 0-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      27.753162,
      28.166609,
      '11- 4-1996',
      NULL,
      NULL,
      NULL,
      39,
      ' 9- 1-2003',
      2,
      ' 2-24-1979',
      10,
      0,
      NULL,
      122,
      23.055132,
      '11-22-1985',
      1,
      0,
      ' 4-19-1995',
      NULL,
      NULL,
      NULL,
      2,
      1,
      24.509707,
      ' 6-22-1988',
      39.670904,
      NULL,
      8.218048,
      ' 3-26-1974',
      0,
      79,
      '10- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


