set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935282';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12400340',
      '33014210',
      '23044322',
      '10104024',
      '23211113',
      '31010324',
      '43202020',
      '44343213',
      '23102240',
      '30021134',
      '23101430',
      '24220431',
      '30331000',
      '12343134',
      '42121004',
      '40040023',
      '33301444',
      NULL,
      '02010033',
      '44124023',
      '12320321',
      NULL,
      NULL,
      NULL,
      '42002442',
      NULL,
      NULL,
      '01212024',
      '32040000',
      '31214231',
      '01124010',
      NULL,
      '42301432',
      '12031010',
      '41243410',
      '32002044',
      '12431043',
      '42012302',
      '33201211',
      NULL,
      NULL,
      '34113113',
      '23123133',
      '01203330',
      '',
      '',
      NULL,
      NULL,
      '0320433',
      2.880868,
      NULL,
      2,
      NULL,
      '444411',
      3.745506,
      ' 1-24-1989',
      ' 8- 3-1995',
      7.332808,
      NULL,
      8.317644,
      NULL,
      4.367031,
      NULL,
      0,
      19,
      4,
      6.182940,
      0.592018,
      19,
      NULL,
      21,
      NULL,
      27,
      1.460721,
      0.850079,
      34.559687,
      18,
      38,
      15.140573,
      74,
      6,
      NULL,
      NULL,
      125,
      69,
      9.854431,
      33,
      134,
      ' 9-26-2001',
      15.697257,
      39.075367,
      14.074395,
      17.077135,
      59.383996,
      NULL,
      ' 0- 2-2001',
      5,
      1.030775,
      1,
      1.066080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.086152,
      0,
      NULL,
      0,
      1.521746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 4-1981',
      10,
      53.880038,
      NULL,
      115,
      17,
      NULL,
      43.980261,
      NULL,
      0,
      40,
      123.847941,
      50.693361,
      ' 0-16-2001',
      7,
      NULL,
      NULL,
      4.563046,
      NULL,
      0,
      2,
      '11-25-1992',
      NULL,
      16,
      '10- 6-2000',
      1.991181,
      9,
      8.843767,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.715080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 3-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1.583506,
      4,
      '11-15-1978',
      14.739279,
      120.279979,
      NULL,
      14,
      NULL,
      NULL,
      0,
      NULL,
      ' 2- 0-1993',
      NULL,
      NULL,
      NULL,
      13.541340,
      NULL,
      1,
      2,
      20,
      39,
      44.372875,
      6,
      NULL,
      10,
      5.540686,
      48.139205,
      NULL,
      1.244765,
      84.378272,
      0,
      3,
      5,
      NULL,
      1,
      53.635348,
      0,
      7,
      NULL,
      25.281334,
      28,
      52.266617,
      0.347596,
      53,
      NULL,
      0.651222,
      1,
      0,
      3.444300,
      1.630471,
      13.721139,
      56,
      32.615584,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.424312,
      0.259818,
      5,
      16,
      1.660335,
      22.085252,
      1,
      NULL,
      0,
      1.312202,
      36.035017,
      30.142619,
      7.722753,
      28,
      54,
      57.089012,
      13.776973,
      NULL,
      7,
      1,
      2,
      NULL,
      0.269675,
      1.929668,
      1,
      0.380343,
      NULL,
      '11-16-1975',
      ' 0-27-1977',
      ' 9-18-1995',
      ' 1-16-1983',
      NULL,
      ' 5-11-1992',
      ' 1- 5-1995',
      NULL);
commit;
end;
/


