set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9002144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0440',
      '43303142',
      '12423104',
      '23121402',
      NULL,
      '23440414',
      NULL,
      '24404112',
      '40000302',
      '22341420',
      '30342002',
      '41034024',
      '20000133',
      '33231002',
      '02401322',
      '24243201',
      '00130441',
      NULL,
      '40103302',
      NULL,
      NULL,
      '42141311',
      '33101432',
      '12332442',
      NULL,
      '12334220',
      '34214441',
      '03433143',
      '10434233',
      NULL,
      NULL,
      '21422333',
      '23140244',
      '22210141',
      '11401014',
      '32320223',
      '23320343',
      '23414304',
      '32333404',
      '12044433',
      '31232002',
      '20340410',
      '22133042',
      '32334111',
      NULL,
      '432',
      '41',
      NULL,
      NULL,
      '2420023',
      NULL,
      NULL,
      0,
      NULL,
      '432234',
      3,
      ' 9- 4-1992',
      ' 6-18-1980',
      NULL,
      NULL,
      5,
      11,
      3,
      8,
      42,
      9,
      6.471401,
      10.274213,
      NULL,
      7.190835,
      12.850521,
      11,
      NULL,
      NULL,
      12.634513,
      NULL,
      28.619973,
      NULL,
      54,
      17.591312,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      99,
      125,
      11,
      170.322161,
      ' 7-27-1976',
      20.920310,
      55,
      23,
      NULL,
      NULL,
      NULL,
      ' 2-22-1995',
      2,
      0,
      NULL,
      0.526081,
      1.078696,
      NULL,
      NULL,
      2.112410,
      0.682029,
      NULL,
      0,
      1.523813,
      1,
      0.513828,
      0.117008,
      1,
      3.769328,
      1,
      NULL,
      1.416196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      95,
      9.564744,
      7,
      NULL,
      NULL,
      7.145959,
      NULL,
      1,
      1.482866,
      49.388401,
      3,
      1,
      NULL,
      0.077185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 9-1996',
      NULL,
      122.682764,
      NULL,
      69,
      83,
      107.224290,
      5,
      82.625253,
      43,
      48.822292,
      78,
      66,
      ' 4-17-1980',
      NULL,
      NULL,
      7.404440,
      49,
      20,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      ' 2-21-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      6.798604,
      '10- 6-1992',
      33.744335,
      ' 3-28-1997',
      NULL,
      NULL,
      13,
      7,
      '10- 4-1989',
      30,
      NULL,
      ' 5-25-1977',
      11.293783,
      0,
      '11- 4-1983',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      13,
      ' 9-23-1999',
      19,
      17.569050,
      31.480852,
      ' 5-18-1974',
      NULL,
      18.596195,
      ' 6-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10);
commit;
end;
/


