set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8920528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1201',
      '10032243',
      NULL,
      '12303404',
      NULL,
      '23020134',
      NULL,
      '42321243',
      '14020320',
      '20002340',
      '22002141',
      '24201243',
      '12041404',
      '44443442',
      NULL,
      '24134222',
      NULL,
      '32044000',
      '20310401',
      NULL,
      '22023424',
      NULL,
      '41440140',
      '03332033',
      NULL,
      '41141313',
      '14101321',
      '42411034',
      '21231340',
      '00201331',
      NULL,
      '14433344',
      '40440002',
      '00210320',
      '01024204',
      '33303242',
      '40430334',
      NULL,
      '43142121',
      '11333110',
      '10304133',
      '24432033',
      '21112433',
      NULL,
      '20413423',
      '',
      '',
      NULL,
      NULL,
      '1044044',
      2.802683,
      1.020142,
      0,
      NULL,
      '231011',
      0,
      ' 0-11-1993',
      NULL,
      36.159804,
      NULL,
      NULL,
      3.584157,
      3,
      NULL,
      38.362820,
      6,
      8.147161,
      1.338889,
      NULL,
      1,
      3.603922,
      6,
      7,
      NULL,
      0,
      2,
      1.256367,
      0.064596,
      0,
      1.241275,
      NULL,
      6.418223,
      NULL,
      60.571958,
      17.456550,
      18.661072,
      132.883157,
      43,
      55.044516,
      ' 3-22-1994',
      NULL,
      10.834544,
      8,
      NULL,
      31,
      71,
      ' 1- 8-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.967711,
      19,
      3.229831,
      3,
      NULL,
      83,
      4.605256,
      ' 8- 2-2001',
      28,
      NULL,
      '10-25-1995',
      9.996127,
      4.859172,
      0.121330,
      14.716882,
      4.959011,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-28-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      5.245412,
      10,
      NULL,
      NULL,
      NULL,
      ' 6- 7-2000',
      4.972360,
      NULL,
      0.985377,
      12,
      ' 9-25-2001',
      49,
      1,
      216,
      ' 0-15-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      0.521287,
      12.879590,
      0,
      6,
      5,
      1,
      40.998806,
      4.365183,
      6.257770,
      NULL,
      2.141298,
      0,
      112,
      NULL,
      6,
      182.499916,
      NULL,
      1.458872,
      241.702636,
      54.506226,
      15.134916,
      59.146637,
      NULL,
      30.452406,
      0,
      0,
      1,
      NULL,
      0,
      1,
      34,
      NULL,
      37.314890,
      NULL,
      28.424762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      21,
      1,
      1.917704,
      59,
      8.511179,
      6,
      19.722394,
      57.022998,
      43.746538,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 3-1994',
      NULL,
      '10-21-1980',
      NULL,
      '10-28-1991',
      ' 5-20-1999',
      NULL,
      NULL);
commit;
end;
/


